/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.SDKProjectsImportOperation;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.osgi.framework.Version;

public class SDKProjectsImportDataModelProvider
extends FacetProjectCreationDataModelProvider
implements ISDKProjectsImportDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new SDKProjectsImportOperation(this.model);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(propertyName)) {
            String sdkName = this.getStringProperty("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME");
            SDK sdk = SDKManager.getInstance().getSDK(sdkName);
            if (sdk != null) {
                return sdk.getLocation().toOSString();
            }
        } else if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            String sdkLoc = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
            try {
                String sdkVersionValue = SDKUtil.readSDKVersion((String)sdkLoc);
                Version v = new Version(sdkVersionValue);
                return v.toString();
            }
            catch (Exception exception) {}
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SDK_VERSION");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        return propertyNames;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            SDK[] validSDKs = SDKManager.getInstance().getSDKs();
            Object[] values = null;
            String[] descriptions = null;
            if (validSDKs.length == 0) {
                values = new String[]{"__NO__SDK__"};
                descriptions = new String[]{"<None>"};
            } else {
                values = new String[validSDKs.length];
                descriptions = new String[validSDKs.length];
                int i = 0;
                while (i < validSDKs.length) {
                    values[i] = validSDKs[i].getName();
                    descriptions[i] = validSDKs[i].getName();
                    ++i;
                }
            }
            return DataModelPropertyDescriptor.createDescriptors((Object[])values, (String[])descriptions);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void init() {
        super.init();
        IFacetedProjectWorkingCopy facetedProject = this.getFacetedProjectWorkingCopy();
        facetedProject.setSelectedPreset("liferay.portlet.preset");
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        fixedFacets.add(ProjectFacetsManager.getProjectFacet((String)"liferay.ext"));
        facetedProject.setFixedProjectFacets(Collections.unmodifiableSet(fixedFacets));
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            return false;
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IStatus validate(String name) {
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(name)) {
            String sdkLocation = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
            if (SDKUtil.isValidSDKLocation((String)sdkLocation)) {
                return Status.OK_STATUS;
            }
            return ProjectCorePlugin.createErrorStatus((String)"Invalid Plugin SDK location.");
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(name)) {
            String sdkVersion = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_VERSION");
            if (SDKUtil.isValidSDKVersion((String)sdkVersion, (Version)SDKManager.getLeastValidVersion())) {
                return Status.OK_STATUS;
            }
            return ProjectCorePlugin.createErrorStatus((String)("Invalid Plugin SDK version, must be greater than " + SDKManager.getLeastValidVersion()));
        }
        if ("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS".equals(name)) {
            Object[] selectedProjects;
            Object val = this.getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
            if (val instanceof Object[] && (selectedProjects = (Object[])val).length >= 1) {
                return Status.OK_STATUS;
            }
            return ProjectCorePlugin.createErrorStatus((String)"Must select one Liferay project to import.");
        }
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(name)) {
            Object runtime = this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (!(runtime instanceof BridgedRuntime)) {
                return ProjectCorePlugin.createErrorStatus((String)"A valid Liferay runtime must be selected.");
            }
            return Status.OK_STATUS;
        }
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(name)) {
            return Status.OK_STATUS;
        }
        return super.validate(name);
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }
}

