/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class SDKProjectsImportOperation
extends AbstractDataModelOperation
implements ISDKProjectsImportDataModelProperties {
    List<IProject> createdProjects = new ArrayList<IProject>();

    public SDKProjectsImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object[] selectedProjects = (Object[])this.getDataModel().getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        String sdkLocation = this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        if (selectedProjects != null && selectedProjects.length > 0) {
            SDK sdk = SDKManager.getInstance().getSDK((IPath)new Path(sdkLocation));
            if (sdk == null) {
                sdk = SDKUtil.createSDKFromLocation((IPath)new Path(sdkLocation));
            }
            if (sdk != null && sdk.isValid() && !SDKManager.getInstance().containsSDK(sdk)) {
                SDKManager.getInstance().addSDK(sdk);
            }
        }
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        int i = 0;
        while (i < selectedProjects.length) {
            if (selectedProjects[i] instanceof ProjectRecord) {
                try {
                    IProject project = ProjectUtil.importProject((ProjectRecord)selectedProjects[i], runtime, sdkLocation, monitor);
                    if (project != null) {
                        this.createdProjects.add(project);
                    }
                }
                catch (CoreException e) {
                    return ProjectCorePlugin.createErrorStatus((Exception)((Object)e));
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

