/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.facet;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.FileListing;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.project.core.util.WebXMLDescriptorHelper;
import com.liferay.ide.eclipse.sdk.ISDKConstants;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class PluginFacetInstall
implements IDelegate,
IPluginProjectDataModelProperties {
    private static final String PATH_IN_PROJECT = ".settings/org.eclipse.wst.common.project.facet.core.prefs.xml";
    protected IDataModel masterModel = null;
    protected IDataModel model = null;
    protected IProgressMonitor monitor;
    protected IProject project;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (!(config instanceof IDataModel)) {
            return;
        }
        this.model = (IDataModel)config;
        this.masterModel = (IDataModel)this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        this.project = project;
        this.monitor = monitor;
        try {
            IFile f = this.project.getProject().getFile(PATH_IN_PROJECT);
            File file = f.getLocation().toFile();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wsroot = ws.getRoot();
            Path path = new Path(file.getAbsolutePath());
            Object[] wsFiles = wsroot.findFilesForLocation((IPath)path);
            if (!CoreUtil.isNullOrEmpty((Object[])wsFiles)) {
                Object[] objectArray = wsFiles;
                int n = wsFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Object wsFile = objectArray[n2];
                    wsFile.getParent().getParent().refreshLocal(2, null);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
        if (this.shouldInstallPluginLibraryDelegate()) {
            this.installPluginLibraryDelegate();
        }
    }

    protected void configWebXML() {
        WebXMLDescriptorHelper webXmlHelper = new WebXMLDescriptorHelper(this.project);
        TagLibRefType tagLibRefType = JspFactory.eINSTANCE.createTagLibRefType();
        tagLibRefType.setTaglibURI("http://java.sun.com/portlet_2_0");
        tagLibRefType.setTaglibLocation("/WEB-INF/tld/liferay-portlet.tld");
        try {
            webXmlHelper.addTagLib(tagLibRefType);
        }
        catch (Exception e) {
            ProjectCorePlugin.logError("Failed to add taglib reference", e);
        }
    }

    protected void copyToProject(IPath parent, File newFile, boolean prompt) throws CoreException, IOException {
        if (newFile == null || !this.shouldCopyToProject(newFile)) {
            return;
        }
        Object projectEntry = null;
        Path newFilePath = new Path(newFile.getPath());
        IPath newFileRelativePath = newFilePath.makeRelativeTo(parent);
        projectEntry = newFile.isDirectory() ? this.project.getFolder(newFileRelativePath) : this.project.getFile(newFileRelativePath);
        if (projectEntry.exists()) {
            if (projectEntry instanceof IFolder) {
                return;
            }
            if (projectEntry instanceof IFile) {
                if (prompt && !this.promptForOverwrite((IResource)projectEntry)) {
                    return;
                }
                ((IFile)projectEntry).setContents((InputStream)new FileInputStream(newFile), 1, null);
            }
        } else if (projectEntry instanceof IFolder) {
            IFolder newProjectFolder = projectEntry;
            newProjectFolder.create(true, true, null);
        } else if (projectEntry instanceof IFile) {
            ((IFile)projectEntry).create((InputStream)new FileInputStream(newFile), 1, null);
        }
    }

    protected boolean deletePath(IPath path) {
        if (path != null && path.toFile().exists()) {
            return path.toFile().delete();
        }
        return false;
    }

    protected ILiferayRuntime getLiferayRuntime() {
        try {
            return ServerUtil.getLiferayRuntime((IProject)this.project);
        }
        catch (CoreException e) {
            ProjectCorePlugin.logError((Throwable)e);
            return null;
        }
    }

    protected IPath getAppServerDir() {
        IRuntime serverRuntime = this.masterModel != null ? (IRuntime)this.masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") : this.getFacetedProject().getPrimaryRuntime();
        return ServerUtil.getAppServerDir((IRuntime)serverRuntime);
    }

    protected IDataModel getFacetDataModel(String facetId) {
        IFacetedProjectWorkingCopy fp = this.getFacetedProject();
        for (IProjectFacetVersion pfv : fp.getProjectFacets()) {
            IFacetedProject.Action action;
            if (!pfv.getProjectFacet().getId().equals(facetId) || (action = fp.getProjectFacetAction(pfv.getProjectFacet())) == null) continue;
            Object config = action.getConfig();
            return (IDataModel)Platform.getAdapterManager().getAdapter(config, IDataModel.class);
        }
        return null;
    }

    protected IFacetedProjectWorkingCopy getFacetedProject() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    protected IPath getPortalDir() {
        IRuntime serverRuntime = this.masterModel != null ? (IRuntime)this.masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") : this.getFacetedProject().getPrimaryRuntime();
        return ServerUtil.getPortalDir((IRuntime)serverRuntime);
    }

    protected String getRuntimeLocation() {
        try {
            return ServerUtil.getRuntime((IProject)this.project).getLocation().toOSString();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected SDK getSDK() {
        String sdkName = null;
        try {
            sdkName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
        }
        catch (Exception exception) {}
        if (sdkName == null) {
            try {
                sdkName = this.model.getStringProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
            }
            catch (Exception exception) {}
        }
        return SDKManager.getInstance().getSDK(sdkName);
    }

    protected IFolder getWebRootFolder() {
        IDataModel webFacetDataModel = null;
        if (this.masterModel != null) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            webFacetDataModel = map.getFacetDataModel(IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getId());
        } else {
            webFacetDataModel = this.getFacetDataModel("jst.web");
        }
        IPath webrootFullPath = null;
        if (webFacetDataModel != null) {
            webrootFullPath = this.project.getFullPath().append(webFacetDataModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
        } else {
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
            if (component != null) {
                webrootFullPath = component.getRootFolder().getUnderlyingFolder().getFullPath();
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(webrootFullPath);
    }

    protected void installPluginLibraryDelegate() throws CoreException {
        LibraryInstallDelegate libraryDelegate = (LibraryInstallDelegate)this.model.getProperty("IPluginProjectDataModelProperties.LIFERAY_PLUGIN_LIBRARY_DELEGATE");
        libraryDelegate.execute(this.monitor);
    }

    protected void installThemeTemplate() throws CoreException {
        SDK sdk = this.getSDK();
        String themeName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.THEME_NAME");
        String displayName = this.masterModel.getStringProperty("IPluginProjectCreationPropertiesNew.DISPLAY_NAME");
        IPath newThemePath = sdk.createNewThemeProject(themeName, displayName);
        this.processNewFiles(newThemePath.append(String.valueOf(themeName) + "-theme"), false);
        newThemePath.toFile().delete();
        this.project.refreshLocal(2, this.monitor);
    }

    protected boolean isProjectInSDK() {
        return this.masterModel.getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION");
    }

    protected void processNewFiles(IPath path, boolean prompt) throws CoreException {
        try {
            List newFiles = FileListing.getFileListing((File)path.toFile());
            for (File file : newFiles) {
                try {
                    this.copyToProject(path, file, prompt);
                }
                catch (Exception e) {
                    ProjectCorePlugin.logError((Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e1) {
            throw new CoreException(ProjectCorePlugin.createErrorStatus((Exception)e1));
        }
    }

    protected boolean promptForOverwrite(final IResource projectEntryPath) {
        final boolean[] retval = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                retval[0] = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Overwrite project file?", (String)("Overwrite project file: " + projectEntryPath.getLocation()));
            }
        });
        return retval[0];
    }

    protected void setupDefaultOutputLocation() throws CoreException {
        IJavaProject jProject = JavaCore.create((IProject)this.project);
        IFolder folder = this.project.getFolder("docroot/WEB-INF/classes");
        if (folder.getParent().exists()) {
            CoreUtil.prepareFolder((IFolder)folder);
            IPath oldOutputLocation = jProject.getOutputLocation();
            IFolder oldOutputFolder = CoreUtil.getWorkspaceRoot().getFolder(oldOutputLocation);
            jProject.setOutputLocation(folder.getFullPath(), null);
            if (oldOutputFolder.exists()) {
                oldOutputFolder.delete(true, null);
            }
        }
    }

    protected boolean shouldCopyToProject(File file) {
        if (this.isProjectInSDK()) {
            return true;
        }
        String[] stringArray = ISDKConstants.PORTLET_PLUGIN_ZIP_IGNORE_FILES;
        int n = ISDKConstants.PORTLET_PLUGIN_ZIP_IGNORE_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (file.getName().equals(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean shouldInstallPluginLibraryDelegate() {
        return true;
    }
}

