/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.facet;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.FileUtil;
import com.liferay.ide.eclipse.project.core.IPortletFramework;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.facet.PluginFacetInstall;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class PortletPluginFacetInstall
extends PluginFacetInstall {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        super.execute(project, fv, config, monitor);
        IDataModel model = (IDataModel)config;
        IDataModel masterModel = (IDataModel)model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (masterModel != null && masterModel.getBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION")) {
            IDataModel fragmentModel;
            SDK sdk = this.getSDK();
            String portletName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.PORTLET_NAME");
            String displayName = this.masterModel.getStringProperty("IPluginProjectCreationPropertiesNew.DISPLAY_NAME");
            IPortletFramework portletFramework = (IPortletFramework)this.masterModel.getProperty("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK");
            String frameworkName = portletFramework.getShortName();
            Map appServerProperties = ServerUtil.configureAppServerProperties((IProject)project);
            IPath newPortletPath = sdk.createNewPortletProject(portletName, displayName, frameworkName, appServerProperties);
            this.processNewFiles(newPortletPath.append(String.valueOf(portletName) + "-portlet"), false);
            FileUtil.deleteDir((File)newPortletPath.toFile(), (boolean)true);
            this.project.refreshLocal(2, monitor);
            if (masterModel.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_ENABLED") && (fragmentModel = masterModel.getNestedModel("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_DM")) != null) {
                try {
                    IFolder docroot;
                    IFile viewJsp;
                    if (fragmentModel.getBooleanProperty("IPluginWizardFragmentProperties.REMOVE_EXISTING_ARTIFACTS") && (viewJsp = (docroot = CoreUtil.getDocroot((IProject)this.project)).getFile("view.jsp")).exists()) {
                        viewJsp.delete(true, monitor);
                    }
                }
                catch (Exception ex) {
                    ProjectCorePlugin.logError("Error deleting view.jsp", ex);
                }
            }
        } else {
            this.setupDefaultOutputLocation();
        }
        this.copyPortletTLD();
        this.configWebXML();
        this.project.refreshLocal(2, monitor);
    }

    protected void copyPortletTLD() throws CoreException {
        IPath portalDir = this.getPortalDir();
        IPath portletTld = portalDir.append("WEB-INF/tld/liferay-portlet.tld");
        if (portletTld.toFile().exists()) {
            IFolder tldFolder = this.getWebRootFolder().getFolder("WEB-INF/tld");
            CoreUtil.prepareFolder((IFolder)tldFolder);
            IFile tldFile = tldFolder.getFile("liferay-portlet.tld");
            if (!tldFile.exists()) {
                try {
                    tldFile.create((InputStream)new FileInputStream(portletTld.toFile()), true, null);
                }
                catch (FileNotFoundException e) {
                    throw new CoreException(ProjectCorePlugin.createErrorStatus((Exception)e));
                }
            }
        }
    }
}

