/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.taglib.ui.snippets;

import com.liferay.ide.eclipse.taglib.ui.model.ITag;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.swt.SapphireDialog;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;

public class AlloyTagInsertDialog
extends SapphireDialog {
    protected List<DisposeListener> disposeListeners = new ArrayList<DisposeListener>();
    protected ISnippetItem fItem = null;
    protected String fPreparedText = null;

    public AlloyTagInsertDialog(Shell host, IModelElement model, String dialogDefPath, boolean clearModality) {
        super(host, model, dialogDefPath);
        if (clearModality) {
            this.setShellStyle(2160);
        } else {
            this.setShellStyle(0x10 | this.getShellStyle());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(600, 730);
    }

    public void addDisposeListener(DisposeListener listener) {
        if (!this.disposeListeners.contains(listener)) {
            this.disposeListeners.add(listener);
        }
    }

    public void create() {
        super.create();
        int i = 0;
        while (i < this.disposeListeners.size()) {
            this.getShell().addDisposeListener(this.disposeListeners.get(i));
            ++i;
        }
        this.getShell().setActive();
    }

    protected void prepareText() {
        String text = (String)((ITag)this.getModelElement()).getSource().getContent();
        text = StringUtils.replace((String)text, (String)"${cursor}", (String)"");
        String systemEOL = System.getProperty("line.separator");
        text = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        text = StringUtils.replace((String)text, (String)"\r", (String)"\n");
        if (!"\n".equals(systemEOL) && systemEOL != null) {
            text = StringUtils.replace((String)text, (String)"\n", (String)systemEOL);
        }
        this.setPreparedText(text);
    }

    public ISnippetItem getItem() {
        return this.fItem;
    }

    public String getPreparedText() {
        if (this.fPreparedText == null) {
            this.prepareText();
        }
        return this.fPreparedText;
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.disposeListeners.remove(listener);
    }

    public void setItem(ISnippetItem item) {
        this.fItem = item;
    }

    protected void setPreparedText(String preparedText) {
        this.fPreparedText = preparedText;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText("Insert");
    }
}

