/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.taglib.ui.snippets;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.taglib.ui.TaglibUI;
import com.liferay.ide.eclipse.taglib.ui.model.ITag;
import com.liferay.ide.eclipse.taglib.ui.snippets.AlloyTagInsertDialog;
import com.liferay.ide.eclipse.ui.snippets.SnippetsUIPlugin;
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlloyTagItemHelper {
    public static String getInsertString(Shell host, ISnippetItem item, IEditorInput editorInput) {
        return AlloyTagItemHelper.getInsertString(host, item, editorInput, true);
    }

    public static String getInsertString(final Shell host, ISnippetItem item, IEditorInput editorInput, boolean clearModality) {
        int result;
        AlloyTagInsertDialog dialog;
        String insertString;
        block10: {
            if (item == null) {
                return "";
            }
            insertString = null;
            ITag model = AlloyTagItemHelper.getTagModel(editorInput, (ISnippetsEntry)item);
            dialog = new AlloyTagInsertDialog(host, model, "com.liferay.ide.eclipse.taglib.ui/com/liferay/ide/eclipse/taglib/ui/snippets/AlloyTag.sdef!tagInsertDialog", clearModality);
            result = 1;
            try {
                try {
                    if (clearModality) {
                        host.setEnabled(false);
                        dialog.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent arg0) {
                                host.setEnabled(true);
                            }
                        });
                    }
                    result = dialog.open();
                }
                catch (Exception t) {
                    SnippetsUIPlugin.logError((Exception)t);
                    if (clearModality) {
                        host.setEnabled(true);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (clearModality) {
                    host.setEnabled(true);
                }
                throw throwable;
            }
            if (clearModality) {
                host.setEnabled(true);
            }
        }
        insertString = result == 0 ? dialog.getPreparedText() : null;
        return insertString;
    }

    private static ITag getTagModel(IEditorInput editorInput, ISnippetsEntry item) {
        Object name;
        Element alloyTag;
        DocumentBuilderFactory docFactory;
        XmlResourceStore store;
        block18: {
            if (!(editorInput instanceof IFileEditorInput) || item == null) {
                return null;
            }
            IFile tldFile = null;
            store = null;
            IFile editorFile = ((IFileEditorInput)editorInput).getFile();
            Object tldDocument = null;
            docFactory = DocumentBuilderFactory.newInstance();
            tldFile = CoreUtil.getDocroot((IProject)editorFile.getProject()).getFile("WEB-INF/tld/alloy.tld");
            if (tldFile.exists()) {
                try {
                    IDOMModel tldModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(tldFile);
                    tldDocument = tldModel.getDocument();
                }
                catch (Exception e) {
                    SnippetsUIPlugin.logError((Exception)e);
                }
            } else {
                try {
                    URL alloyURL = FileLocator.toFileURL((URL)TaglibUI.getDefault().getBundle().getEntry("deps/alloy.tld"));
                    File alloyFile = new File(alloyURL.getFile());
                    tldDocument = docFactory.newDocumentBuilder().parse(alloyFile);
                }
                catch (Exception e) {
                    SnippetsUIPlugin.logError((Exception)e);
                }
            }
            if (tldDocument == null) {
                return null;
            }
            NodeList tags = tldDocument.getElementsByTagName("tag");
            alloyTag = null;
            int i = 0;
            while (i < tags.getLength()) {
                Element tag = (Element)tags.item(i);
                NodeList children = tag.getElementsByTagName("name");
                if (children.getLength() > 0) {
                    name = children.item(0).getChildNodes().item(0).getNodeValue();
                    if (item.getLabel().equals(name)) {
                        alloyTag = tag;
                        break;
                    }
                }
                ++i;
            }
            if (alloyTag != null) break block18;
            return null;
        }
        try {
            DocumentBuilder newDocumentBuilder = docFactory.newDocumentBuilder();
            Document doc = newDocumentBuilder.newDocument();
            Element destTag = doc.createElement("tag");
            name = doc.createElement("name");
            name.appendChild(doc.createTextNode(item.getLabel()));
            destTag.appendChild((Node)name);
            Element prefix = doc.createElement("prefix");
            prefix.appendChild(doc.createTextNode("alloy"));
            destTag.appendChild(prefix);
            Element required = (Element)destTag.appendChild(doc.createElement("required"));
            Element events = (Element)destTag.appendChild(doc.createElement("events"));
            Element other = (Element)destTag.appendChild(doc.createElement("other"));
            NodeList attrs = alloyTag.getElementsByTagName("attribute");
            int i = 0;
            while (i < attrs.getLength()) {
                try {
                    Element attr = (Element)attrs.item(i);
                    String desc = ((Element)attr.getElementsByTagName("description").item(0)).getFirstChild().getNodeValue();
                    String json = desc.substring(desc.indexOf("<!--") + 4, desc.indexOf("-->"));
                    JSONObject jsonObject = new JSONObject(json);
                    Node newAttr = null;
                    newAttr = jsonObject.getBoolean("required") ? required.appendChild(doc.importNode(attr, true)) : (jsonObject.getBoolean("event") ? events.appendChild(doc.importNode(attr, true)) : other.appendChild(doc.importNode(attr, true)));
                    if (jsonObject.has("defaultValue")) {
                        Element defaultValElement = doc.createElement("default-value");
                        defaultValElement.appendChild(doc.createTextNode(jsonObject.get("defaultValue").toString()));
                        newAttr.appendChild(defaultValElement);
                    }
                }
                catch (Exception e) {
                    TaglibUI.logError(e);
                }
                ++i;
            }
            doc.appendChild(destTag);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            store = new XmlResourceStore(xmlString.getBytes());
        }
        catch (Exception e) {
            TaglibUI.logError(e);
        }
        return (ITag)ITag.TYPE.instantiate((Resource)new RootXmlResource(store));
    }
}

