/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.core.util;

import com.liferay.ide.eclipse.core.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtil {
    public static IFolder getDocroot(String projectName) {
        IProject project = CoreUtil.getProject(projectName);
        return CoreUtil.getDocroot(project);
    }

    public static boolean isResourceInDocroot(IModuleResource resource) {
        IFile file = (IFile)resource.getAdapter(IFile.class);
        if (file != null) {
            IFolder docroot = CoreUtil.getDocroot(file.getProject());
            return docroot != null && docroot.exists() && docroot.getFullPath().isPrefixOf(file.getFullPath());
        }
        return false;
    }

    public static boolean containsMember(IModuleResourceDelta delta, String[] paths) {
        if (delta == null) {
            return false;
        }
        IModuleResourceDelta[] currentChildren = delta.getAffectedChildren();
        if (currentChildren == null) {
            IFile file = (IFile)delta.getModuleResource().getAdapter(IFile.class);
            if (file != null) {
                String filePath = file.getFullPath().toString();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (filePath.contains(path)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        int j = 0;
        int jmax = currentChildren.length;
        while (j < jmax) {
            IPath moduleRelativePath = currentChildren[j].getModuleRelativePath();
            String moduleRelativePathValue = moduleRelativePath.toString();
            String moduleRelativeLastSegment = moduleRelativePath.lastSegment();
            String[] stringArray = paths;
            int n = paths.length;
            int n3 = 0;
            while (n3 < n) {
                String path = stringArray[n3];
                if (moduleRelativePathValue.equals(path) || moduleRelativeLastSegment.equals(path)) {
                    return true;
                }
                ++n3;
            }
            boolean childContains = CoreUtil.containsMember(currentChildren[j], paths);
            if (childContains) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, "com.liferay.ide.eclipse.core", msg);
    }

    public static void deleteResource(IResource resource) throws CoreException {
        if (resource == null || !resource.exists()) {
            return;
        }
        resource.delete(true, null);
    }

    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }

    public static IProject getProject(String projectName) {
        return CoreUtil.getWorkspaceRoot().getProject(projectName);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static Object invoke(String methodName, Object object, Class<?>[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getMethod(methodName, argTypes);
        return method.invoke(object, args);
    }

    public static boolean isEqual(Object object1, Object object2) {
        return object1 != null && object2 != null && object1.equals(object2);
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(String val) {
        return val == null || val.equals("") || val.trim().equals("");
    }

    public static IProgressMonitor newSubMonitor(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    public static void prepareFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CoreUtil.prepareFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(1, true, null);
        }
    }

    public static String readPropertyFileValue(File propertiesFile, String key) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propertiesFile));
        return props.getProperty(key);
    }

    public static String readStreamToString(InputStream contents) throws IOException {
        int read;
        if (contents == null) {
            return null;
        }
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(contents, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    public static Version readVersionFile(File versionInfoFile) {
        String versionContents = FileUtil.readContents(versionInfoFile);
        if (CoreUtil.isNullOrEmpty(versionContents)) {
            return Version.emptyVersion;
        }
        Version version = null;
        try {
            version = Version.parseVersion((String)versionContents.trim());
        }
        catch (NumberFormatException numberFormatException) {
            version = Version.emptyVersion;
        }
        return version;
    }

    public static IFolder getDocroot(IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent comp;
        IContainer retval = null;
        if (project != null && (comp = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = comp.getRootFolder()) != null) {
            retval = rootFolder.getUnderlyingFolder();
        }
        return retval instanceof IFolder ? (IFolder)retval : null;
    }
}

