/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.core.util;

import com.liferay.ide.eclipse.core.CorePlugin;
import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.StringBufferOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class FileUtil {
    public static void clearContents(File versionFile) {
        if (versionFile != null && versionFile.exists()) {
            try {
                RandomAccessFile file = new RandomAccessFile(versionFile, "rw");
                file.setLength(0L);
                file.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void copyFileToDir(File file, File dir) {
        block25: {
            if (!(file != null && file.exists() && dir != null && dir.exists() && dir.isDirectory())) {
                return;
            }
            byte[] buf = new byte[4096];
            OutputStream out = null;
            FileInputStream in = null;
            try {
                try {
                    out = new FileOutputStream(new File(dir, file.getName()));
                    in = new FileInputStream(file);
                    int avail = in.read(buf);
                    while (avail > 0) {
                        out.write(buf, 0, avail);
                        avail = in.read(buf);
                    }
                }
                catch (Exception exception) {
                    CorePlugin.logError("Unable to copy file " + file.getName() + " to " + dir.getAbsolutePath());
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception2) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block25;
                    }
                    catch (Exception exception3) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteDir(File directory, boolean removeAll) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && removeAll) {
                FileUtil.deleteDir(file, removeAll);
            } else {
                file.delete();
            }
            ++n2;
        }
        directory.delete();
    }

    public static void deleteDirContents(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.deleteDir(file, true);
            } else {
                file.delete();
            }
            ++n2;
        }
    }

    public static String readContents(File file) {
        return FileUtil.readContents(file, false);
    }

    public static String readContents(File file, boolean includeNewlines) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        StringBuffer contents = new StringBuffer();
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                contents.append(line);
                if (!includeNewlines) continue;
                contents.append("\n");
            }
        }
        catch (Exception exception) {
            CorePlugin.logError("Could not read file: " + file.getPath());
        }
        return contents.toString();
    }

    public static String readContents(InputStream contents) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedInputStream bin = new BufferedInputStream(contents);
        StringBufferOutputStream out = new StringBufferOutputStream();
        int bytesRead = 0;
        while ((bytesRead = bin.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (bin != null) {
            bin.close();
        }
        if (out != null) {
            out.flush();
            out.close();
        }
        return out.toString();
    }

    public static String[] readLinesFromFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Exception exception) {
            CorePlugin.logError("Could not read file: " + file.getPath());
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static Document readXMLFile(File file) {
        return FileUtil.readXMLFile(file, null);
    }

    public static Document readXMLFile(File file, EntityResolver resolver) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (resolver != null) {
                db.setEntityResolver(resolver);
            }
            return db.parse(file);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String validateNewFolder(IFolder docroot, String folderValue) {
        if (docroot == null || folderValue == null) {
            return null;
        }
        if (CoreUtil.isNullOrEmpty(folderValue)) {
            return "Folder value cannot be empty.";
        }
        if (!Path.ROOT.isValidPath(folderValue)) {
            return "Folder value is invalid.";
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(docroot.getFolder(folderValue).getFullPath().toString(), 2);
        if (!result.isOK()) {
            return result.getMessage();
        }
        if (docroot.getFolder((IPath)new Path(folderValue)).exists()) {
            return "Folder already exists.";
        }
        return null;
    }

    public static int writeFileFromStream(File tempFile, InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
        BufferedInputStream bin = new BufferedInputStream(in);
        int bytesRead = 0;
        int bytesTotal = 0;
        while ((bytesRead = bin.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            bytesTotal += bytesRead;
        }
        if (bin != null) {
            bin.close();
        }
        if (out != null) {
            out.flush();
            out.close();
        }
        return bytesTotal;
    }
}

