/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.ui.wizard;

import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.ui.LiferayServerUIPlugin;
import com.liferay.ide.eclipse.server.ui.wizard.LiferayRuntimeStubComposite;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class LiferayRuntimeStubWizardFragment
extends WizardFragment {
    public static final String LIFERAY_RUNTIME_STUB = "liferay-runtime-stub";
    protected LiferayRuntimeStubComposite composite;

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        wizard.setTitle("Liferay Runtime");
        wizard.setDescription("Specify the location of the runtime directory.");
        wizard.setImageDescriptor(ImageDescriptor.createFromURL((URL)LiferayServerUIPlugin.getDefault().getBundle().getEntry("/icons/wizban/server_wiz.png")));
        this.composite = new LiferayRuntimeStubComposite(parent, wizard);
        return this.composite;
    }

    public void enter() {
        if (this.composite != null) {
            IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.composite.setRuntime(runtime);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate(null);
        return status != null && status.getSeverity() != 4;
    }

    protected ILiferayRuntime getLiferayRuntime() {
        IRuntimeWorkingCopy runtimeWC = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        ILiferayRuntime liferayRuntime = (ILiferayRuntime)runtimeWC.loadAdapter(ILiferayRuntime.class, null);
        return liferayRuntime;
    }
}

