/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.internal.MemoryResource;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementType
extends ModelMetadataItem {
    private final Class<?> modelElementClass;
    private Class<?> implClass = null;
    private Constructor<?> implClassConstructor = null;
    private boolean implClassLoaded = false;
    private final List<ModelProperty> properties;
    private final LocalizationService localizationService;
    private ImageData image;
    private boolean imageInitialized;

    public ModelElementType(Class<?> modelElementClass) {
        this.modelElementClass = modelElementClass;
        this.properties = new ArrayList<ModelProperty>();
        this.localizationService = LocalizationSystem.service(this.modelElementClass);
    }

    public static ModelElementType getModelElementType(Class<?> modelElementClass) {
        return ModelElementType.getModelElementType(modelElementClass, true);
    }

    public static ModelElementType getModelElementType(Class<?> modelElementClass, boolean throwExceptionIfNotFound) {
        Field[] fieldArray = modelElementClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("TYPE")) {
                try {
                    Object fieldValue = field.get(null);
                    if (!(fieldValue instanceof ModelElementType)) break;
                    return (ModelElementType)fieldValue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        if (throwExceptionIfNotFound) {
            throw new IllegalArgumentException("Did not find TYPE field on " + modelElementClass.getName());
        }
        return null;
    }

    public Class<?> getModelElementClass() {
        return this.modelElementClass;
    }

    public String getSimpleName() {
        return this.modelElementClass.getSimpleName();
    }

    public String getQualifiedName() {
        return this.modelElementClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getImplClass() {
        ModelElementType modelElementType = this;
        synchronized (modelElementType) {
            if (!this.implClassLoaded) {
                this.implClassLoaded = true;
                GenerateImpl generateImplAnnotation = this.getAnnotation(GenerateImpl.class);
                if (generateImplAnnotation != null) {
                    String implPackage = generateImplAnnotation.packageName();
                    if (implPackage.length() == 0) {
                        implPackage = String.valueOf(this.modelElementClass.getPackage().getName()) + ".internal";
                    }
                    String implClassName = this.modelElementClass.getSimpleName().substring(1);
                    String implClassQualifiedName = String.valueOf(implPackage) + "." + implClassName;
                    try {
                        this.implClass = this.modelElementClass.getClassLoader().loadClass(implClassQualifiedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    if (this.implClass != null) {
                        try {
                            this.implClassConstructor = this.implClass.getConstructor(IModelParticle.class, ModelProperty.class, Resource.class);
                        }
                        catch (NoSuchMethodException e) {
                            LoggingService.log(e);
                            this.implClass = null;
                        }
                    }
                }
            }
            return this.implClass;
        }
    }

    public <T extends IModelElement> T instantiate(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        this.getImplClass();
        if (this.implClassConstructor != null) {
            try {
                return (T)((IModelElement)this.implClassConstructor.newInstance(parent, parentProperty, resource));
            }
            catch (Exception e) {
                String msg = NLS.bind(Resources.cannotInstantiate, this.getSimpleName());
                throw new RuntimeException(msg, e);
            }
        }
        String msg = NLS.bind(Resources.cannotInstantiate, this.getSimpleName());
        throw new RuntimeException(msg);
    }

    public <T extends IModelElement> T instantiate(Resource resource) {
        return this.instantiate(null, null, resource);
    }

    public <T extends IModelElement> T instantiate() {
        return this.instantiate(null, null, new MemoryResource(this));
    }

    public List<ModelProperty> getProperties() {
        TreeMap<String, ModelProperty> properties = new TreeMap<String, ModelProperty>();
        Class<?>[] classArray = this.modelElementClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            ModelElementType t = ModelElementType.getModelElementType(cl, false);
            if (t != null) {
                for (ModelProperty property : t.getProperties()) {
                    properties.put(property.getName(), property);
                }
            }
            ++n2;
        }
        for (ModelProperty property : this.properties) {
            properties.put(property.getName(), property);
        }
        return new ArrayList<ModelProperty>(properties.values());
    }

    public ModelProperty getProperty(String propertyName) {
        for (ModelProperty property : this.getProperties()) {
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            return property;
        }
        return null;
    }

    void addProperty(ModelProperty property) {
        this.properties.add(property);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type, boolean localOnly) {
        return this.modelElementClass.getAnnotation(type);
    }

    public Class<?> getAnnotationHostClass(Annotation annotation) {
        return this.modelElementClass;
    }

    @Override
    protected String getDefaultLabel() {
        String className = this.modelElementClass.getName();
        int start = className.lastIndexOf(46) + 1;
        int startPlusOne = start + 1;
        if (className.charAt(start) == 'I' && startPlusOne < className.length() && Character.isUpperCase(className.charAt(startPlusOne))) {
            start = startPlusOne;
        }
        if (start > 0) {
            className = className.substring(start);
        }
        return LocalizationUtil.transformCamelCaseToLabel(className);
    }

    @Override
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public ImageData image() {
        if (!this.imageInitialized) {
            Image imageAnnotation = this.getAnnotation(Image.class);
            if (imageAnnotation != null) {
                try {
                    this.image = ImageData.createFromClassLoader(this.getAnnotationHostClass(imageAnnotation), imageAnnotation.path());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            this.imageInitialized = true;
        }
        return this.image;
    }

    protected static abstract class ModelPropertyInitListener {
        protected ModelPropertyInitListener() {
        }

        public abstract void propertyInitialized(ModelProperty var1);
    }

    private static final class Resources
    extends NLS {
        public static String cannotInstantiate;

        static {
            Resources.initializeMessages(ModelElementType.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

