/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelElementServiceFactory;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.TypeCast;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireModelingExtensionSystem {
    private static final String EL_VALUE_SERIALIZATION_SERVICE = "value-serialization-service";
    private static final String EL_MODEL_ELEMENT_SERVICE = "model-element-service";
    private static final String EL_MODEL_PROPERTY_SERVICE = "model-property-service";
    private static final String EL_FUNCTION = "function";
    private static final String EL_NAME = "name";
    private static final String EL_TYPE = "type";
    private static final String EL_FACTORY = "factory";
    private static final String EL_IMPL = "impl";
    private static final String EL_ID = "id";
    private static final String EL_OVERRIDES = "overrides";
    private static final String EL_SOURCE = "source";
    private static final String EL_TARGET = "target";
    private static final String EL_TYPE_CAST = "type-cast";
    private static boolean initialized = false;
    private static List<ModelElementServiceFactoryProxy> modelElementServiceFactories;
    private static List<ModelPropertyServiceFactoryProxy> modelPropertyServiceFactories;
    private static List<ValueSerializationServiceFactory> valueSerializerFactories;
    private static Map<String, FunctionFactory> functionFactories;
    private static List<TypeCast> typeCasts;

    public static List<ModelElementServiceFactoryProxy> getModelElementServices() {
        SapphireModelingExtensionSystem.initialize();
        return modelElementServiceFactories;
    }

    public static List<ModelPropertyServiceFactoryProxy> getModelPropertyServices() {
        SapphireModelingExtensionSystem.initialize();
        return modelPropertyServiceFactories;
    }

    public static ValueSerializationService createValueSerializer(IModelElement element, ValueProperty property, Class<?> type) {
        SapphireModelingExtensionSystem.initialize();
        for (ValueSerializationServiceFactory factory : valueSerializerFactories) {
            ValueSerializationService instance;
            if (!factory.applicable(type) || (instance = factory.create(element, property)) == null) continue;
            return instance;
        }
        return null;
    }

    public static Function createFunction(String name, Function ... operands) {
        SapphireModelingExtensionSystem.initialize();
        FunctionFactory factory = functionFactories.get(name.toLowerCase());
        if (factory != null) {
            return factory.create(operands);
        }
        return null;
    }

    public static List<TypeCast> getTypeCasts() {
        SapphireModelingExtensionSystem.initialize();
        return typeCasts;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            modelElementServiceFactories = new ArrayList<ModelElementServiceFactoryProxy>();
            modelPropertyServiceFactories = new ArrayList<ModelPropertyServiceFactoryProxy>();
            valueSerializerFactories = new ArrayList<ValueSerializationServiceFactory>();
            functionFactories = new HashMap<String, FunctionFactory>();
            typeCasts = new ArrayList<TypeCast>();
            for (ExtensionsLocator.Handle handle : ExtensionsLocator.instance().find()) {
                Element root = SapphireModelingExtensionSystem.parse(handle.extension());
                if (root == null) continue;
                NodeList nodes = root.getChildNodes();
                int i = 0;
                int n = nodes.getLength();
                while (i < n) {
                    Node node = nodes.item(i);
                    if (node instanceof Element) {
                        Element el = (Element)node;
                        String elname = el.getLocalName();
                        try {
                            Set<String> overrides;
                            Class serviceFactory;
                            Class serviceType;
                            String id;
                            if (elname.equals(EL_VALUE_SERIALIZATION_SERVICE)) {
                                Class valueType = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TYPE)));
                                Class serializerClass = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_IMPL)));
                                valueSerializerFactories.add(new ValueSerializationServiceFactory(valueType, serializerClass));
                            } else if (elname.equals(EL_MODEL_ELEMENT_SERVICE)) {
                                id = SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_ID));
                                serviceType = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TYPE)));
                                serviceFactory = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_FACTORY)));
                                overrides = SapphireModelingExtensionSystem.parseOverrides(el);
                                modelElementServiceFactories.add(new ModelElementServiceFactoryProxy(id, serviceType, serviceFactory, overrides));
                            } else if (elname.equals(EL_MODEL_PROPERTY_SERVICE)) {
                                id = SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_ID));
                                serviceType = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TYPE)));
                                serviceFactory = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_FACTORY)));
                                overrides = SapphireModelingExtensionSystem.parseOverrides(el);
                                modelPropertyServiceFactories.add(new ModelPropertyServiceFactoryProxy(id, serviceType, serviceFactory, overrides));
                            } else if (elname.equals(EL_FUNCTION)) {
                                String name = SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_NAME));
                                Class impl = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_IMPL)));
                                functionFactories.put(name.toLowerCase(), new FunctionFactory(impl));
                            } else if (elname.equals(EL_TYPE_CAST)) {
                                Class source = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_SOURCE)));
                                Class target = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_TARGET)));
                                Class impl = handle.findClass(SapphireModelingExtensionSystem.text(SapphireModelingExtensionSystem.child(el, EL_IMPL)));
                                typeCasts.add(new TypeCastProxy(source, target, impl));
                            }
                        }
                        catch (InvalidExtensionException invalidExtensionException) {}
                    }
                    ++i;
                }
            }
        }
    }

    private static Set<String> parseOverrides(Element root) {
        Set<String> overrides = null;
        NodeList nodes = root.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            String text;
            Node node = nodes.item(i);
            if (node instanceof Element && node.getLocalName().equals(EL_OVERRIDES) && (text = SapphireModelingExtensionSystem.text((Element)node)).length() > 0) {
                if (overrides == null) {
                    overrides = new HashSet<String>();
                }
                overrides.add(text);
            }
            ++i;
        }
        if (overrides == null) {
            overrides = Collections.emptySet();
        }
        return overrides;
    }

    private static Element parse(URL url) {
        Element element;
        InputStream in = url.openStream();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            DocumentBuilder docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = docbuilder.parse(in);
            element = document.getDocumentElement();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return element;
    }

    private static Element child(Element element, String name) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Element el;
            Node node = nodes.item(i);
            if (node instanceof Element && name.equals((el = (Element)node).getLocalName())) {
                return el;
            }
            ++i;
        }
        throw new InvalidExtensionException();
    }

    private static String text(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node instanceof Text) {
                buf.append(((Text)node).getData());
            }
            ++i;
        }
        return buf.toString().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionFactory {
        private final Class<? extends Function> functionClass;
        private boolean functionInstantiationFailed;

        public FunctionFactory(Class<? extends Function> functionClass) {
            this.functionClass = functionClass;
        }

        public Function create(Function ... operands) {
            Function function = null;
            if (!this.functionInstantiationFailed) {
                try {
                    function = this.functionClass.newInstance();
                    function.init(operands);
                }
                catch (Exception e) {
                    LoggingService.log(e);
                    function = null;
                    this.functionInstantiationFailed = true;
                }
            }
            return function;
        }
    }

    public static final class InvalidExtensionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ModelElementServiceFactoryProxy
    extends ModelElementServiceFactory {
        private final String id;
        private final Class<? extends ModelElementService> type;
        private final Class<? extends ModelElementServiceFactory> factoryClass;
        private final Set<String> overrides;
        private ModelElementServiceFactory factoryInstance;
        private boolean factoryInstantiationFailed;

        public ModelElementServiceFactoryProxy(String id, Class<? extends ModelElementService> type, Class<? extends ModelElementServiceFactory> factoryClass, Set<String> overrides) {
            this.id = id;
            this.type = type;
            this.factoryClass = factoryClass;
            this.overrides = overrides;
        }

        public String id() {
            return this.id;
        }

        @Override
        public boolean applicable(IModelElement element, Class<? extends ModelElementService> service) {
            ModelElementServiceFactory factory;
            boolean result = false;
            if (service.isAssignableFrom(this.type) && (factory = this.factory()) != null) {
                result = factory.applicable(element, service);
            }
            return result;
        }

        public Set<String> overrides() {
            return this.overrides;
        }

        @Override
        public ModelElementService create(IModelElement element, Class<? extends ModelElementService> service) {
            ModelElementService result = null;
            ModelElementServiceFactory factory = this.factory();
            if (factory != null) {
                result = factory.create(element, service);
            }
            return result;
        }

        private synchronized ModelElementServiceFactory factory() {
            if (this.factoryInstance == null && !this.factoryInstantiationFailed) {
                try {
                    this.factoryInstance = this.factoryClass.newInstance();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                    this.factoryInstantiationFailed = true;
                }
            }
            return this.factoryInstance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ModelPropertyServiceFactoryProxy
    extends ModelPropertyServiceFactory {
        private final String id;
        private final Class<? extends ModelPropertyService> type;
        private final Class<? extends ModelPropertyServiceFactory> factoryClass;
        private final Set<String> overrides;
        private ModelPropertyServiceFactory factoryInstance;
        private boolean factoryInstantiationFailed;

        public ModelPropertyServiceFactoryProxy(String id, Class<? extends ModelPropertyService> type, Class<? extends ModelPropertyServiceFactory> factoryClass, Set<String> overrides) {
            this.id = id;
            this.type = type;
            this.factoryClass = factoryClass;
            this.overrides = overrides;
        }

        public String id() {
            return this.id;
        }

        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            ModelPropertyServiceFactory factory;
            boolean result = false;
            if (service.isAssignableFrom(this.type) && (factory = this.factory()) != null) {
                result = factory.applicable(element, property, service);
            }
            return result;
        }

        public Set<String> overrides() {
            return this.overrides;
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            ModelPropertyService result = null;
            ModelPropertyServiceFactory factory = this.factory();
            if (factory != null) {
                result = factory.create(element, property, service);
            }
            return result;
        }

        private synchronized ModelPropertyServiceFactory factory() {
            if (this.factoryInstance == null && !this.factoryInstantiationFailed) {
                try {
                    this.factoryInstance = this.factoryClass.newInstance();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                    this.factoryInstantiationFailed = true;
                }
            }
            return this.factoryInstance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeCastProxy
    extends TypeCast {
        private final Class<?> source;
        private final Class<?> target;
        private final Class<? extends TypeCast> implClass;
        private TypeCast implInstance;
        private boolean implInstantiationFailed;

        public TypeCastProxy(Class<?> source, Class<?> target, Class<? extends TypeCast> implementation) {
            this.source = source;
            this.target = target;
            this.implClass = implementation;
        }

        @Override
        public boolean applicable(FunctionContext context, Function requestor, Object value, Class<?> target) {
            if (!(this.implInstantiationFailed || target != this.target || value != null && value.getClass() != this.source)) {
                if (this.implInstance == null) {
                    try {
                        this.implInstance = this.implClass.newInstance();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                        this.implInstantiationFailed = true;
                    }
                }
                if (!this.implInstantiationFailed) {
                    return this.implInstance.applicable(context, requestor, value, target);
                }
            }
            return false;
        }

        @Override
        public Object evaluate(FunctionContext context, Function requestor, Object value, Class<?> target) {
            if (this.implInstance == null || this.implInstantiationFailed) {
                throw new IllegalStateException();
            }
            return this.implInstance.evaluate(context, requestor, value, target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueSerializationServiceFactory {
        private final Class<?> type;
        private final Class<? extends ValueSerializationService> serializerClass;
        private boolean serializerInstantiationFailed;

        public ValueSerializationServiceFactory(Class<?> type, Class<? extends ValueSerializationService> serializerClass) {
            this.type = type;
            this.serializerClass = serializerClass;
        }

        public boolean applicable(Class<?> type) {
            boolean result = false;
            if (this.type.isAssignableFrom(type)) {
                result = true;
            }
            return result;
        }

        public ValueSerializationService create(IModelElement element, ValueProperty property) {
            ValueSerializationService serializer = null;
            if (!this.serializerInstantiationFailed) {
                try {
                    serializer = this.serializerClass.newInstance();
                    serializer.init(element, property, new String[0]);
                }
                catch (Exception e) {
                    LoggingService.log(e);
                    serializer = null;
                    this.serializerInstantiationFailed = true;
                }
            }
            return serializer;
        }
    }
}

