/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation;

import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;

public final class PathValidation {
    public static final Status validateExtensions(String fileName, String[] validFileExtensions) {
        if (validFileExtensions != null && validFileExtensions.length > 0) {
            String trimmedFileName = fileName.trim();
            int lastdot = trimmedFileName.lastIndexOf(46);
            String extension = lastdot == -1 ? "" : trimmedFileName.substring(lastdot + 1);
            boolean match = false;
            if (extension != null && extension.length() != 0) {
                String[] stringArray = validFileExtensions;
                int n = validFileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (extension.equalsIgnoreCase(ext)) {
                        match = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!match) {
                String message;
                if (validFileExtensions.length == 1) {
                    message = NLS.bind(Resources.invalidFileExtensionOne, trimmedFileName, validFileExtensions[0]);
                } else if (validFileExtensions.length == 2) {
                    message = NLS.bind(Resources.invalidFileExtensionOne, trimmedFileName, validFileExtensions[0], validFileExtensions[1]);
                } else {
                    StringBuilder buf = new StringBuilder();
                    String[] stringArray = validFileExtensions;
                    int n = validFileExtensions.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String ext = stringArray[n3];
                        if (buf.length() != 0) {
                            buf.append(", ");
                        }
                        buf.append(ext);
                        ++n3;
                    }
                    message = NLS.bind(Resources.invalidFileExtensionMultiple, trimmedFileName, buf.toString());
                }
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    protected static final class Resources
    extends NLS {
        public static String invalidFileExtensionOne;
        public static String invalidFileExtensionTwo;
        public static String invalidFileExtensionMultiple;

        static {
            Resources.initializeMessages(PathValidation.class.getName(), Resources.class);
        }

        protected Resources() {
        }
    }
}

