/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation.internal;

import java.io.File;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.validation.PathValidationService;

public final class AbsolutePathValidationService
extends PathValidationService {
    public Status validate() {
        Value value = (Value)this.target();
        Path path = (Path)value.getContent(false);
        if (path != null) {
            File f = path.toFile();
            if (f.exists()) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (f.isFile()) {
                        return this.validateExtensions(path);
                    }
                    String message = PathValidationService.Resources.bind(PathValidationService.Resources.pathIsNotFile, path.toString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && !f.isDirectory()) {
                    String message = PathValidationService.Resources.bind(PathValidationService.Resources.pathIsNotFolder, path.toString());
                    return Status.createErrorStatus(message);
                }
            } else if (this.resourceMustExist) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    String message = PathValidationService.Resources.bind(PathValidationService.Resources.fileMustExist, path.toString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    String message = PathValidationService.Resources.bind(PathValidationService.Resources.folderMustExist, path.toString());
                    return Status.createErrorStatus(message);
                }
                String message = PathValidationService.Resources.bind(PathValidationService.Resources.resourceMustExist, path.toString());
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && property.hasAnnotation(AbsolutePath.class) && Path.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new AbsolutePathValidationService();
        }
    }
}

