/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceValidationService
extends ModelPropertyValidationService<ReferenceValue<?, ?>> {
    @Override
    public Status validate() {
        ReferenceValue value = (ReferenceValue)this.target();
        if (value.resolve() == null && value.getText() != null) {
            ValueProperty property = value.getProperty();
            String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
            String str = value.getText();
            String msg = NLS.bind(Resources.message, label, str);
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && property.hasAnnotation(Reference.class) && property.hasAnnotation(MustExist.class);
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new ReferenceValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages(ReferenceValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

