/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequiredPropertyValidationService<T>
extends ModelPropertyValidationService<T> {
    @Override
    public final Status validate() {
        if (this.check()) {
            return Status.createOkStatus();
        }
        String label = this.property().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
        String message = NLS.bind(Resources.message, label);
        return Status.createErrorStatus(message);
    }

    protected abstract boolean check();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property.hasAnnotation(Required.class) && (property instanceof ValueProperty || property instanceof ElementProperty && !(property instanceof ImpliedElementProperty));
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            if (property instanceof ValueProperty) {
                return new RequiredPropertyValidationService<Value<?>>(){

                    @Override
                    protected boolean check() {
                        return ((Value)this.target()).getText() != null;
                    }
                };
            }
            return new RequiredPropertyValidationService<ModelElementHandle<?>>(){

                @Override
                protected boolean check() {
                    return ((ModelElementHandle)this.target()).element() != null;
                }
            };
        }
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages(RequiredPropertyValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

