/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.ui.action;

import com.liferay.ide.eclipse.portlet.core.PortletCore;
import com.liferay.ide.eclipse.portlet.core.job.BuildLanguageJob;
import com.liferay.ide.eclipse.portlet.ui.PortletUIPlugin;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.project.ui.action.AbstractProjectAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class BuildLanguagesAction
extends AbstractProjectAction {
    public void run(IAction action) {
        IFile langFile = null;
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            Object elem = elems[0];
            if (elem instanceof IFile) {
                langFile = (IFile)elem;
            } else if (elem instanceof IProject) {
                IFolder[] srcFolders;
                IProject project = (IProject)elem;
                IFolder[] iFolderArray = srcFolders = ProjectUtil.getSourceFolders((IProject)project);
                int n = srcFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder src = iFolderArray[n2];
                    IFile file = src.getFile("content/Language.properties");
                    if (file.exists()) {
                        langFile = file;
                        break;
                    }
                    ++n2;
                }
            }
            if (langFile.exists()) {
                try {
                    boolean shouldContinue = this.checkLanguageFileEncoding(langFile);
                    if (!shouldContinue) {
                        return;
                    }
                }
                catch (Exception e2) {
                    PortletUIPlugin.createErrorStatus(e2);
                }
                BuildLanguageJob job = PortletCore.createBuildLanguageJob((IFile)langFile);
                job.schedule();
            }
        }
    }

    protected boolean checkLanguageFileEncoding(IFile langFile) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        langFile.refreshLocal(2, (IProgressMonitor)monitor);
        String charset = langFile.getCharset(true);
        if (!"UTF-8".equals(charset)) {
            String dialogMessage = "The language file character set is set to " + charset + " which could lead to unexpected results.  Liferay expects the file to be encoded as UTF-8.  Would you like to force Eclipse to recognize this file as UTF-8?";
            MessageDialog dialog = new MessageDialog(this.getDisplay().getActiveShell(), "Incompatible Character Set", this.getDisplay().getSystemImage(8), dialogMessage, 4, new String[]{"Yes", "No", "Cancel"}, 0);
            int retval = dialog.open();
            if (retval == 0) {
                langFile.setCharset("UTF-8", (IProgressMonitor)monitor);
                String question = String.valueOf(langFile.getName()) + " has been forced to use UTF-8 encoding.  Would you like to edit the file to verify the contents?";
                if (MessageDialog.openQuestion((Shell)this.getDisplay().getActiveShell(), (String)"Preview file", (String)question)) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)langFile);
                }
                return false;
            }
            if (retval == 2) {
                return false;
            }
        }
        return true;
    }
}

