/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.ui.editor;

import com.liferay.ide.eclipse.core.util.FileListing;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PortalTldViewerFilter
extends ViewerFilter {
    protected File base;
    protected List<File> cachedDirs = new ArrayList<File>();
    protected String[] existingTlds = null;
    protected String[] roots = null;
    protected IPath[] validRoots;

    public PortalTldViewerFilter(File base, String[] roots, String[] existingTlds) {
        this.base = base;
        this.roots = roots;
        this.existingTlds = existingTlds;
        this.validRoots = new IPath[roots.length];
        int i = 0;
        while (i < roots.length) {
            File fileRoot = new File(base, roots[i]);
            if (fileRoot.exists()) {
                this.validRoots[i] = new Path(fileRoot.getPath());
            }
            ++i;
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof File) {
            File file = (File)element;
            Path filePath = new Path(file.getPath());
            boolean validRootFound = false;
            Object[] objectArray = this.validRoots;
            int n = this.validRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPath validRoot = objectArray[n2];
                if (validRoot.isPrefixOf((IPath)filePath)) {
                    validRootFound = true;
                    break;
                }
                ++n2;
            }
            if (!validRootFound) {
                return false;
            }
            if (this.cachedDirs.contains(file)) {
                return true;
            }
            if (file.isDirectory()) {
                if (this.directoryContainsFiles(file, "tld", viewer)) {
                    this.cachedDirs.add(file);
                    return true;
                }
            } else {
                objectArray = this.existingTlds;
                n = this.existingTlds.length;
                n2 = 0;
                while (n2 < n) {
                    IPath existingJar = objectArray[n2];
                    if (filePath.lastSegment().equals(existingJar.trim())) {
                        return false;
                    }
                    ++n2;
                }
                if (filePath.getFileExtension().contains("tld")) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean directoryContainsFiles(File dir, String ext, Viewer viewer) {
        try {
            File file;
            Path filePath;
            List files = FileListing.getFileListing((File)dir);
            Iterator iterator = files.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((filePath = new Path((file = (File)iterator.next()).getPath())).getFileExtension() == null || !filePath.getFileExtension().contains(ext));
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return false;
    }
}

