/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.portlet.core.operation.INewHookDataModelProperties;
import com.liferay.ide.eclipse.portlet.ui.PortletUIPlugin;
import com.liferay.ide.eclipse.portlet.ui.wizard.CustomJSPsTableWizardSection;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import com.liferay.ide.eclipse.ui.wizard.StringArrayTableWizardSection;
import com.liferay.ide.eclipse.ui.wizard.StringArrayTableWizardSectionCallback;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class NewCustomJSPsHookWizardPage
extends DataModelWizardPage
implements INewHookDataModelProperties {
    protected Text customJSPsFolder;
    protected Button disableJSPFolderValidation;
    protected CustomJSPsTableWizardSection jspItemsSection;

    public NewCustomJSPsHookWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName, "Create Custom JSPs", PortletUIPlugin.imageDescriptorFromPlugin((String)"com.liferay.ide.eclipse.portlet.ui", (String)"/icons/wizban/hook_wiz.png"));
        this.setDescription("Create customs JSP folder and select JSPs to override.");
    }

    protected void createCustomJSPsGroup(Composite parent) {
        Composite composite = SWTUtil.createTopComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.jspItemsSection = new CustomJSPsTableWizardSection(composite, "JSP files to override", "JSP File Path", "Add...", "Edit...", "Remove...", new String[]{"Add"}, new String[]{"JSP File Path"}, null, this.getDataModel(), "INewHookDataModelProperties.CUSTOM_JSPS_ITEMS");
        GridData gd = new GridData(4, 0x1000000, true, true, 1, 1);
        gd.heightHint = 175;
        this.jspItemsSection.setLayoutData(gd);
        this.jspItemsSection.setCallback((StringArrayTableWizardSection.StringArrayDialogCallback)new StringArrayTableWizardSectionCallback());
        IProject project = CoreUtil.getProject((String)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        if (project != null) {
            try {
                ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)project);
                IPath portalDir = liferayRuntime.getPortalDir();
                if (portalDir != null && portalDir.toFile().exists()) {
                    this.jspItemsSection.setPortalDir(portalDir.toFile());
                }
            }
            catch (CoreException e) {
                PortletUIPlugin.logError((Exception)((Object)e));
            }
        }
    }

    protected void createDisableJSPFolderValidation(Composite topComposite) {
        Composite composite = SWTUtil.createTopComposite((Composite)topComposite, (int)3);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.disableJSPFolderValidation = new Button(composite, 32);
        this.disableJSPFolderValidation.setText("Disable JSP syntax validation for custom JSP folder (recommended).");
        this.synchHelper.synchCheckbox(this.disableJSPFolderValidation, "INewHookDataModelProperties.DISABLE_CUSTOM_JSP_FOLDER_VALIDATION", null);
    }

    protected void createJSPFolderGroup(Composite topComposite) {
        Composite composite = SWTUtil.createTopComposite((Composite)topComposite, (int)3);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        SWTUtil.createLabel((Composite)composite, (int)16384, (String)"Custom JSP folder:", (int)1);
        this.customJSPsFolder = SWTUtil.createText((Composite)composite, (int)1);
        this.synchHelper.synchText(this.customJSPsFolder, "INewHookDataModelProperties.CUSTOM_JSPS_FOLDER", null);
        Button iconFileBrowse = SWTUtil.createPushButton((Composite)composite, (String)"Browse...", null);
        iconFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCustomJSPsHookWizardPage.this.handleFileBrowseButton(NewCustomJSPsHookWizardPage.this.customJSPsFolder);
            }
        });
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        this.createJSPFolderGroup(topComposite);
        this.createCustomJSPsGroup(topComposite);
        this.createDisableJSPFolderValidation(topComposite);
        return topComposite;
    }

    protected void enter() {
        super.enter();
        this.synchHelper.synchAllUIWithModel();
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] != null && !(selection[0] instanceof IProject) && !(selection[0] instanceof IFile)) {
                    return Status.OK_STATUS;
                }
                return PortletUIPlugin.createErrorStatus("Choose a valid folder for custom jsps.");
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(NewCustomJSPsHookWizardPage.this.model.getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
                }
                return element instanceof IFolder;
            }
        };
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"INewHookDataModelProperties.CUSTOM_JSPS_FOLDER", "INewHookDataModelProperties.CUSTOM_JSPS_ITEMS"};
    }

    protected void handleFileBrowseButton(Text text) {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(J2EEUIMessages.CONTAINER_SELECTION_DIALOG_TITLE);
        dialog.setMessage(J2EEUIMessages.CONTAINER_SELECTION_DIALOG_DESC);
        dialog.addFilter(filter);
        dialog.setInput((Object)CoreUtil.getWorkspaceRoot());
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    if (folder.equals((Object)CoreUtil.getDocroot((String)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME")))) {
                        folder = folder.getFolder("custom_jsps");
                    }
                    text.setText(folder.getFullPath().toPortableString());
                }
            }
            catch (Exception exception) {}
        }
    }
}

