/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.portlet.core.operation.INewHookDataModelProperties;
import com.liferay.ide.eclipse.portlet.ui.PortletUIPlugin;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import com.liferay.ide.eclipse.ui.wizard.LiferayDataModelWizardPage;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewHookTypeWizardPage
extends LiferayDataModelWizardPage
implements INewHookDataModelProperties {
    protected Button customJSPButton;
    protected Button folderButton;
    protected Text folderText;
    protected Button languagePropertiesButton;
    protected Button portalPropertiesButton;
    protected String projectName;
    protected Combo projectNameCombo;
    protected Label projectNameLabel;
    protected Button servicesButton;

    public NewHookTypeWizardPage(IDataModel model, String pageName) {
        super(model, pageName, "Create Liferay Hook", PortletUIPlugin.imageDescriptorFromPlugin((String)"com.liferay.ide.eclipse.portlet.ui", (String)"/icons/wizban/hook_wiz.png"));
        this.setDescription("Define a new hook plugin.");
    }

    protected void createHookTypesGroup(Composite parent) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)"Select hook type(s) to create", (int)1);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.customJSPButton = SWTUtil.createCheckButton((Composite)group, (String)"Custom JSPs", null, (boolean)false, (int)1);
        this.synchHelper.synchCheckbox(this.customJSPButton, "INewHookDataModelProperties.CREATE_CUSTOM_JSPS", null);
        this.portalPropertiesButton = SWTUtil.createCheckButton((Composite)group, (String)"Portal properties", null, (boolean)false, (int)1);
        this.synchHelper.synchCheckbox(this.portalPropertiesButton, "INewHookDataModelProperties.CREATE_PORTAL_PROPERTIES", null);
        this.servicesButton = SWTUtil.createCheckButton((Composite)group, (String)"Services", null, (boolean)false, (int)1);
        this.synchHelper.synchCheckbox(this.servicesButton, "INewHookDataModelProperties.CREATE_SERVICES", null);
        this.languagePropertiesButton = SWTUtil.createCheckButton((Composite)group, (String)"Language properties", null, (boolean)false, (int)1);
        this.synchHelper.synchCheckbox(this.languagePropertiesButton, "INewHookDataModelProperties.CREATE_LANGUAGE_PROPERTIES", null);
    }

    protected void createProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText("Hook plugin project:");
        this.projectNameLabel.setLayoutData((Object)new GridData());
        GridData data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.projectNameCombo = new Combo(parent, 2056);
        this.projectNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.initializeProjectList();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)2);
        this.createProjectNameGroup(topComposite);
        SWTUtil.createVerticalSpacer((Composite)topComposite, (int)2, (int)2);
        this.createHookTypesGroup(topComposite);
        this.setShellImage();
        return topComposite;
    }

    protected IFolder getDocroot() {
        return CoreUtil.getDocroot((String)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IArtifactEditOperationDataModelProperties.PROJECT_NAME", "INewHookDataModelProperties.CREATE_CUSTOM_JSPS", "INewHookDataModelProperties.CREATE_PORTAL_PROPERTIES", "INewHookDataModelProperties.CREATE_SERVICES", "INewHookDataModelProperties.CREATE_LANGUAGE_PROPERTIES"};
    }

    protected void initializeProjectList() {
        IProject[] workspaceProjects = CoreUtil.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = CoreUtil.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        try {
            if (selectedProject == null) {
                selectedProject = this.getSelectedProject();
            }
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                this.projectNameCombo.setText(selectedProject.getName());
                this.validateProjectRequirements(selectedProject);
                this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException coreException) {}
        if (this.projectName == null && names.length > 0) {
            this.projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.validateProjectRequirements(CoreUtil.getProject((String)this.projectName));
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
        }
    }

    protected boolean isProjectValid(IProject project) {
        return ProjectUtil.isHookProject((IProject)project) || ProjectUtil.isPortletProject((IProject)project);
    }

    protected void setShellImage() {
        URL url = PortletUIPlugin.getDefault().getBundle().getEntry("/icons/e16/hook.png");
        Image shellImage = ImageDescriptor.createFromURL((URL)url).createImage();
        this.getShell().setImage(shellImage);
    }
}

