/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.eclipse.portlet.ui.PortletUIPlugin;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.ui.dialog.FilteredTypesSelectionDialogEx;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewPortletClassWizardPage
extends NewJavaClassWizardPage
implements INewPortletClassDataModelProperties {
    protected Button createNewClassRadio;
    protected Button customButton;
    protected Button folderButton;
    protected Text folderText;
    protected boolean fragment;
    protected Button portletClassButton;
    protected Label portletClassLabel;
    protected Text portletClassText;
    protected String projectName = null;
    protected Combo projectNameCombo;
    protected Label projectNameLabel;
    protected Combo superCombo;
    protected Button useDefaultPortletRadio;

    public NewPortletClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, boolean fragment) {
        super(model, pageName, pageDesc, pageTitle, "jst.web");
        this.fragment = fragment;
    }

    protected void createClassnameGroup(Composite parent) {
        this.classLabel = new Label(parent, 16384);
        this.classLabel.setText("Portlet class:");
        this.classLabel.setLayoutData((Object)new GridData(256));
        this.classText = new Text(parent, 2052);
        this.classText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.classText, "NewJavaClassDataModel.CLASS_NAME", null);
        new Label(parent, 16384);
    }

    protected void createFolderGroup(Composite composite) {
        Label folderLabel = new Label(composite, 16384);
        folderLabel.setText(J2EEUIMessages.FOLDER_LABEL);
        folderLabel.setLayoutData((Object)new GridData(256));
        this.folderText = new Text(composite, 2052);
        this.folderText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.folderText, "NewJavaClassDataModel.SOURCE_FOLDER", null);
        IPackageFragmentRoot root = this.getSelectedPackageFragmentRoot();
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0) {
            IProject targetProject = ProjectUtilities.getProject((String)projectName);
            if (root == null || !root.getJavaProject().getProject().equals((Object)targetProject)) {
                IFolder folder = this.getDefaultJavaSourceFolder(targetProject);
                if (folder != null) {
                    this.folderText.setText(folder.getFullPath().toPortableString());
                }
            } else {
                this.folderText.setText(root.getPath().toString());
            }
        }
        this.folderButton = new Button(composite, 8);
        this.folderButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.folderButton.setLayoutData((Object)new GridData(256));
        this.folderButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewPortletClassWizardPage.this.handleFolderButtonPressed();
            }
        });
    }

    protected void createNewPortletClassGroup(Composite parent) {
        new Label(parent, 16384);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createNewClassRadio = new Button(composite, 16);
        this.createNewClassRadio.setText("Create new portlet");
        this.useDefaultPortletRadio = new Button(composite, 16);
        this.useDefaultPortletRadio.setText("Use default portlet (MVCPortlet)");
        new Label(parent, 0);
        this.synchHelper.synchRadio(this.createNewClassRadio, "INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS", null);
        this.synchHelper.synchRadio(this.useDefaultPortletRadio, "INewPortletClassDataModelProperties.USE_DEFAULT_PORTLET_CLASS", null);
        this.createNewClassRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPortletClassWizardPage.this.classText.setEnabled(NewPortletClassWizardPage.this.createNewClassRadio.getSelection());
                NewPortletClassWizardPage.this.packageText.setEnabled(NewPortletClassWizardPage.this.createNewClassRadio.getSelection());
                NewPortletClassWizardPage.this.superCombo.setEnabled(NewPortletClassWizardPage.this.createNewClassRadio.getSelection());
            }
        });
    }

    protected void createPackageGroup(Composite parent) {
        this.packageLabel = new Label(parent, 16384);
        this.packageLabel.setText(J2EEUIMessages.JAVA_PACKAGE_LABEL);
        this.packageLabel.setLayoutData((Object)new GridData(256));
        this.packageText = new Text(parent, 2052);
        this.packageText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.packageText, "NewJavaClassDataModel.JAVA_PACKAGE", null);
        IPackageFragment packageFragment = this.getSelectedPackageFragment();
        String targetProject = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (packageFragment != null && packageFragment.exists() && packageFragment.getJavaProject().getElementName().equals(targetProject)) {
            IPackageFragmentRoot root = this.getPackageFragmentRoot(packageFragment);
            if (root != null) {
                this.folderText.setText(root.getPath().toString());
            }
            this.model.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)packageFragment.getElementName());
        }
        if (this.fragment) {
            SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        } else {
            this.packageButton = new Button(parent, 8);
            this.packageButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
            this.packageButton.setLayoutData((Object)new GridData(256));
            this.packageButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NewPortletClassWizardPage.this.handlePackageButtonPressed();
                }
            });
        }
    }

    protected void createPortletClassGroup(Composite parent) {
        if (!this.fragment && this.getDataModel().getBooleanProperty("INewPortletClassDataModelProperties.SHOW_NEW_CLASS_OPTION")) {
            this.createNewPortletClassGroup(parent);
        }
        this.createClassnameGroup(parent);
        this.createPackageGroup(parent);
        this.createSuperclassGroup(parent);
    }

    protected void createProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText("Portlet plugin project:");
        this.projectNameLabel.setLayoutData((Object)new GridData());
        this.projectNameCombo = new Combo(parent, 2056);
        GridData data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.projectNameCombo.setLayoutData((Object)data);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                IProject project = CoreUtil.getProject((String)NewPortletClassWizardPage.this.projectNameCombo.getText());
                NewPortletClassWizardPage.this.validateProjectRequirements(project);
            }
        });
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.initializeProjectList();
        new Label(parent, 0);
    }

    protected void createSuperclassGroup(Composite parent) {
        this.superLabel = new Label(parent, 16384);
        this.superLabel.setText(J2EEUIMessages.SUPERCLASS_LABEL);
        this.superLabel.setLayoutData((Object)new GridData(256));
        this.superCombo = new Combo(parent, 4);
        this.superCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.superCombo, "NewJavaClassDataModel.SUPERCLASS", null);
        if (this.fragment) {
            SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        } else {
            this.superButton = new Button(parent, 8);
            this.superButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
            this.superButton.setLayoutData((Object)new GridData(256));
            this.superButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NewPortletClassWizardPage.this.handleClassButtonSelected((Control)NewPortletClassWizardPage.this.superCombo, "javax.portlet.GenericPortlet", J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_TITLE, J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_DESC);
                }
            });
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        if (!this.fragment) {
            this.createProjectNameGroup(composite);
            this.createFolderGroup(composite);
            this.addSeperator(composite, 3);
        }
        this.createPortletClassGroup(composite);
        this.setFocusOnClassText();
        this.setShellImage();
        return composite;
    }

    protected void enter() {
        super.enter();
        this.validatePage();
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(NewPortletClassWizardPage.this.model.getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
                }
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    IProject project = ProjectUtilities.getProject((String)NewPortletClassWizardPage.this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
                    IPackageFragmentRoot[] sourceFolders = J2EEProjectUtilities.getSourceContainers((IProject)project);
                    int i = 0;
                    while (i < sourceFolders.length) {
                        if (sourceFolders[i].getResource() != null && sourceFolders[i].getResource().equals((Object)folder)) {
                            return true;
                        }
                        if (ProjectUtil.isParent((IFolder)folder, (IResource)sourceFolders[i].getResource())) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
        };
    }

    protected IFolder getDefaultJavaSourceFolder(IProject project) {
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected IPackageFragment getSelectedPackageFragment() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null) {
            if (element.getElementType() == 4) {
                return (IPackageFragment)element;
            }
            if (element.getElementType() == 5) {
                IJavaElement parent = ((ICompilationUnit)element).getParent();
                if (parent.getElementType() == 4) {
                    return (IPackageFragment)parent;
                }
            } else if (element.getElementType() == 7) {
                return ((IType)element).getPackageFragment();
            }
        }
        return null;
    }

    protected IPackageFragmentRoot getSelectedPackageFragmentRoot() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getElementType() == 3) {
            return (IPackageFragmentRoot)element;
        }
        return null;
    }

    protected IProject getSelectedProject() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        return this.getExtendedSelectedProject(stucturedSelection.getFirstElement());
    }

    protected String[] getValidationPropertyNames() {
        ArrayList<String> validationPropertyNames = new ArrayList<String>();
        if (this.fragment) {
            return new String[]{"IArtifactEditOperationDataModelProperties.COMPONENT_NAME", "NewJavaClassDataModel.JAVA_PACKAGE", "NewJavaClassDataModel.CLASS_NAME", "NewJavaClassDataModel.SUPERCLASS"};
        }
        validationPropertyNames.add("INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS");
        validationPropertyNames.add("INewPortletClassDataModelProperties.USE_DEFAULT_PORTLET_CLASS");
        Collections.addAll(validationPropertyNames, super.getValidationPropertyNames());
        return validationPropertyNames.toArray(new String[0]);
    }

    protected void handleClassButtonSelected(Control control, String baseClass, String title, String message) {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        if (packRoot == null) {
            return;
        }
        IJavaSearchScope scope = null;
        try {
            IType type = packRoot.getJavaProject().findType(baseClass);
            if (type == null) {
                return;
            }
            scope = BasicSearchEngine.createHierarchyScope((IType)type);
        }
        catch (JavaModelException e) {
            PortletUIPlugin.logError((Exception)((Object)e));
            return;
        }
        FilteredTypesSelectionDialogEx dialog = new FilteredTypesSelectionDialogEx(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle(title);
        dialog.setMessage(message);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getFirstResult();
            String classFullPath = "";
            if (type != null) {
                classFullPath = type.getFullyQualifiedName();
            }
            if (control instanceof Text) {
                ((Text)control).setText(classFullPath);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(classFullPath);
            }
            this.getControl().setCursor(null);
            return;
        }
        this.getControl().setCursor(null);
    }

    protected void handleCustomButtonSelected() {
    }

    protected void handleFolderButtonPressed() {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(J2EEUIMessages.CONTAINER_SELECTION_DIALOG_TITLE);
        dialog.setMessage(J2EEUIMessages.CONTAINER_SELECTION_DIALOG_DESC);
        dialog.addFilter(filter);
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName == null || projectName.length() == 0) {
            return;
        }
        IProject project = ProjectUtilities.getProject((String)projectName);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (project != null) {
            dialog.setInitialSelection((Object)project);
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    this.folderText.setText(container.getFullPath().toString());
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void initializeProjectList() {
        IProject[] workspaceProjects = CoreUtil.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = CoreUtil.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        try {
            if (selectedProject == null) {
                selectedProject = this.getSelectedProject();
            }
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                this.projectNameCombo.setText(selectedProject.getName());
                this.validateProjectRequirements(selectedProject);
                this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException coreException) {}
        if (this.projectName == null && names.length > 0) {
            this.projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.validateProjectRequirements(CoreUtil.getProject((String)this.projectName));
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
        }
    }

    protected boolean isProjectValid(IProject project) {
        return super.isProjectValid(project) && ProjectUtil.isPortletProject((IProject)project);
    }

    protected void setFocusOnClassText() {
        if (this.classText != null) {
            this.classText.setFocus();
        }
    }

    protected void setShellImage() {
        URL url = PortletUIPlugin.getDefault().getBundle().getEntry("/icons/e16/portlet.png");
        Image shellImage = ImageDescriptor.createFromURL((URL)url).createImage();
        this.getShell().setImage(shellImage);
    }

    protected void validateProjectRequirements(IProject project) {
        super.validateProjectRequirements(project);
    }
}

