/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.portlet.ui.PortletUIPlugin;
import com.liferay.ide.eclipse.portlet.ui.wizard.NewServiceWrapperClassDialog;
import com.liferay.ide.eclipse.portlet.ui.wizard.PortalServiceSearchScope;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import com.liferay.ide.eclipse.ui.dialog.FilteredTypesSelectionDialogEx;
import com.liferay.ide.eclipse.ui.wizard.StringArrayTableWizardSection;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ServicesTableWizardSection
extends StringArrayTableWizardSection {
    protected String[] buttonLabels = new String[]{"Select...", "Select...,New..."};
    protected IProject project;
    protected File servicesPropertiesFile = null;

    public ServicesTableWizardSection(Composite parent, String componentLabel, String dialogTitle, String addButtonLabel, String editButtonLabel, String removeButtonLabel, String[] columnTitles, String[] fieldLabels, Image labelProviderImage, IDataModel model, String propertyName) {
        super(parent, componentLabel, dialogTitle, addButtonLabel, editButtonLabel, removeButtonLabel, columnTitles, fieldLabels, labelProviderImage, model, propertyName);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void handleAddButtonSelected() {
        AddServiceDialog dialog = new AddServiceDialog(this.getShell(), this.dialogTitle, this.fieldLabels, this.buttonLabels);
        if (dialog.open() == 0) {
            String[] stringArray = dialog.getStringArray();
            this.addStringArray(stringArray);
        }
    }

    public class AddServiceDialog
    extends StringArrayTableWizardSection.AddStringArrayDialog {
        protected String[] buttonLabels;

        public AddServiceDialog(Shell shell, String windowTitle, String[] labelsForTextField, String[] buttonLabels) {
            super((StringArrayTableWizardSection)ServicesTableWizardSection.this, shell, windowTitle, labelsForTextField);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.buttonLabels = buttonLabels;
            this.setWidthHint(450);
        }

        protected Text createField(Composite parent, final int index) {
            Label label = new Label(parent, 16384);
            label.setText(this.labelsForTextField[index]);
            label.setLayoutData((Object)new GridData(32));
            final Text text = new Text(parent, 2052);
            GridData data = new GridData(768);
            text.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(parent, 0);
            String[] buttonLbls = this.buttonLabels[index].split(",");
            GridLayout gl = new GridLayout(buttonLbls.length, true);
            gl.marginWidth = 0;
            gl.horizontalSpacing = 1;
            buttonComposite.setLayout((Layout)gl);
            String[] stringArray = buttonLbls;
            int n = buttonLbls.length;
            int n2 = 0;
            while (n2 < n) {
                final String lbl = stringArray[n2];
                Button button = new Button(buttonComposite, 8);
                button.setText(lbl);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddServiceDialog.this.handleArrayDialogButtonSelected(index, lbl, text);
                    }
                });
                ++n2;
            }
            return text;
        }

        protected void handleArrayDialogButtonSelected(int index, String label, Text text) {
            if (index == 0) {
                this.handleSelectServiceButton(text);
            } else if (index == 1 && "Select...".equals(label)) {
                this.handleSelectImplClassButton(text);
            } else if (index == 1 && "New...".equals(label)) {
                this.handleNewImplClassButton(text);
            }
        }

        protected void handleNewImplClassButton(Text text) {
            NewServiceWrapperClassDialog dialog;
            if (CoreUtil.isNullOrEmpty((String)this.texts[0].getText())) {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)"Add Service", (String)"Please specify a service type first.");
                return;
            }
            String serviceType = this.texts[0].getText();
            String wrapperType = "";
            if (serviceType.endsWith("Service")) {
                wrapperType = String.valueOf(serviceType) + "Wrapper";
            }
            if ((dialog = new NewServiceWrapperClassDialog(this.getShell(), ServicesTableWizardSection.this.model, serviceType, wrapperType)).open() == 0) {
                String qualifiedClassname = dialog.getQualifiedClassname();
                text.setText(qualifiedClassname);
            }
        }

        protected void handleSelectImplClassButton(Text text) {
            if (CoreUtil.isNullOrEmpty((String)this.texts[0].getText())) {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)"Add Service", (String)"Please specify a service type first.");
                return;
            }
            IPackageFragmentRoot packRoot = (IPackageFragmentRoot)ServicesTableWizardSection.this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
            if (packRoot == null) {
                return;
            }
            IJavaSearchScope scope = null;
            try {
                String serviceType = this.texts[0].getText();
                if (serviceType.endsWith("Service")) {
                    String wrapperType = String.valueOf(serviceType) + "Wrapper";
                    scope = BasicSearchEngine.createHierarchyScope((IType)packRoot.getJavaProject().findType(wrapperType));
                }
            }
            catch (JavaModelException e) {
                PortletUIPlugin.logError((Exception)((Object)e));
                return;
            }
            FilteredTypesSelectionDialogEx dialog = new FilteredTypesSelectionDialogEx(this.getShell(), false, null, scope, 5);
            dialog.setTitle(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_TITLE);
            dialog.setMessage(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_DESC);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getFirstResult();
                String classFullPath = "";
                if (type != null) {
                    classFullPath = type.getFullyQualifiedName();
                }
                text.setText(classFullPath);
            }
        }

        protected void handleSelectServiceButton(Text text) {
            PortalServiceSearchScope scope = new PortalServiceSearchScope();
            scope.setResourcePattern(new String[]{".*Service.class$"});
            IProject project = ProjectUtil.getProject((IDataModel)ServicesTableWizardSection.this.model);
            try {
                IPath[] libs;
                ILiferayRuntime runtime = ServerUtil.getLiferayRuntime((IProject)project);
                IPath[] iPathArray = libs = runtime.getAllUserClasspathLibraries();
                int n = libs.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath lib = iPathArray[n2];
                    if (lib.lastSegment().equals("portal-service.jar")) {
                        scope.setEnclosingJarPaths(new IPath[]{lib});
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e1) {
                PortletUIPlugin.logError((Exception)((Object)e1));
                return;
            }
            FilteredTypesSelectionDialogEx dialog = new FilteredTypesSelectionDialogEx(this.getShell(), false, null, (IJavaSearchScope)scope, 6);
            dialog.setTitle(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_TITLE);
            dialog.setMessage(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_DESC);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getFirstResult();
                String classFullPath = "";
                if (type != null) {
                    classFullPath = type.getFullyQualifiedName();
                }
                text.setText(classFullPath);
            }
        }
    }
}

