/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphitiFileService {
    public static TransactionalEditingDomain createEmfFileForDiagram(URI diagramResourceUri, final Diagram diagram) {
        TransactionalEditingDomain editingDomain = DiagramEditorFactory.createResourceSetAndEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final Resource resource = resourceSet.createResource(diagramResourceUri);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                resource.setTrackingModification(true);
                resource.getContents().add((Object)diagram);
            }
        });
        GraphitiFileService.save(editingDomain, Collections.<Resource, Map<?, ?>>emptyMap());
        return editingDomain;
    }

    private static void save(TransactionalEditingDomain editingDomain, Map<Resource, Map<?, ?>> options) {
        GraphitiFileService.saveInWorkspaceRunnable(editingDomain, options);
    }

    private static void saveInWorkspaceRunnable(final TransactionalEditingDomain editingDomain, final Map<Resource, Map<?, ?>> options) {
        final HashMap<URI, Throwable> failedSaves = new HashMap<URI, Throwable>();
        IWorkspaceRunnable wsRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Runnable runnable = new Runnable(){

                    public void run() {
                        InternalTransaction parentTx;
                        if (editingDomain != null && (parentTx = ((TransactionalEditingDomainImpl)editingDomain).getActiveTransaction()) != null) {
                            do {
                                if (parentTx.isReadOnly()) continue;
                                throw new IllegalStateException("FileService.save() called from within a command (likely produces a deadlock)");
                            } while ((parentTx = ((TransactionalEditingDomainImpl)editingDomain).getActiveTransaction().getParent()) != null);
                        }
                        EList resources = editingDomain.getResourceSet().getResources();
                        Object[] resourcesArray = new Resource[resources.size()];
                        resourcesArray = (Resource[])resources.toArray(resourcesArray);
                        HashSet<Object> savedResources = new HashSet<Object>();
                        int i = 0;
                        while (i < resourcesArray.length) {
                            Object resource = resourcesArray[i];
                            if (resource.isModified()) {
                                try {
                                    resource.save((Map)options.get(resource));
                                    savedResources.add(resource);
                                }
                                catch (Throwable t) {
                                    failedSaves.put(resource.getURI(), t);
                                }
                            }
                            ++i;
                        }
                    }
                };
                try {
                    editingDomain.runExclusive(runnable);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                editingDomain.getCommandStack().flush();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsRunnable, null);
            if (!failedSaves.isEmpty()) {
                throw new WrappedException(GraphitiFileService.createMessage(failedSaves), (Exception)new RuntimeException());
            }
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static String createMessage(Map<URI, Throwable> failedSaves) {
        StringBuilder buf = new StringBuilder("The following resources could not be saved:");
        for (Map.Entry<URI, Throwable> entry : failedSaves.entrySet()) {
            buf.append("\nURI: ").append(entry.getKey().toString()).append(", cause: \n").append(GraphitiFileService.getExceptionAsString(entry.getValue()));
        }
        return buf.toString();
    }

    private static String getExceptionAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String result = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {}
        printWriter.close();
        return result;
    }

    public static IFile EmfResourceToIFile(Resource resource) {
        IFile ifile = null;
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        String scheme = uri.scheme();
        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
        }
        return ifile;
    }
}

