/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class SapphireCreateConnectionFeature
extends AbstractCreateConnectionFeature {
    private SapphireDiagramEditorPagePart diagramPart;
    private IDiagramConnectionDef connDef;

    public SapphireCreateConnectionFeature(IFeatureProvider fp, SapphireDiagramEditorPagePart diagramPart, IDiagramConnectionDef connDef, String tpLabel, String tpDesc) {
        super(fp, tpLabel, tpDesc);
        this.diagramPart = diagramPart;
        this.connDef = connDef;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        DiagramConnectionTemplate connectionTemplate;
        SapphirePart source = this.getEndpoint(context.getSourceAnchor());
        SapphirePart target = this.getEndpoint(context.getTargetAnchor());
        if (source instanceof DiagramNodePart && target instanceof DiagramNodePart && source != target && (connectionTemplate = this.getConnectionTemplate((DiagramNodePart)source)) != null) {
            return connectionTemplate.canCreateNewConnection((DiagramNodePart)source, (DiagramNodePart)target);
        }
        return false;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        SapphirePart source = this.getEndpoint(context.getSourceAnchor());
        SapphirePart target = this.getEndpoint(context.getTargetAnchor());
        if (source instanceof DiagramNodePart && target instanceof DiagramNodePart) {
            DiagramNodePart sourceNode = (DiagramNodePart)source;
            DiagramNodePart targetNode = (DiagramNodePart)target;
            DiagramConnectionTemplate connectionTemplate = this.getConnectionTemplate(sourceNode);
            if (connectionTemplate instanceof DiagramEmbeddedConnectionTemplate) {
                ((DiagramEmbeddedConnectionTemplate)connectionTemplate).removeModelListener(sourceNode.getLocalModelElement());
            } else {
                connectionTemplate.removeModelListener();
            }
            DiagramConnectionPart connectionPart = connectionTemplate.createNewDiagramConnection(sourceNode, targetNode);
            if (connectionTemplate instanceof DiagramEmbeddedConnectionTemplate) {
                ((DiagramEmbeddedConnectionTemplate)connectionTemplate).addModelListener(sourceNode.getLocalModelElement());
            } else {
                connectionTemplate.addModelListener();
            }
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
            addContext.setNewObject((Object)connectionPart);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        }
        return newConnection;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        DiagramNodePart nodePart;
        DiagramConnectionTemplate connTemplate;
        SapphirePart part = this.getEndpoint(context.getSourceAnchor());
        return part instanceof DiagramNodePart && (connTemplate = this.getConnectionTemplate(nodePart = (DiagramNodePart)part)).canStartNewConnection(nodePart);
    }

    public String getCreateImageId() {
        IDiagramImageChoice imageChoice = (IDiagramImageChoice)this.connDef.getToolPaletteImage().element();
        if (imageChoice != null) {
            return (String)imageChoice.getImageId().getContent();
        }
        return null;
    }

    private SapphirePart getEndpoint(Anchor anchor) {
        Object obj;
        if (anchor != null && (obj = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof SapphirePart) {
            return (SapphirePart)obj;
        }
        return null;
    }

    private DiagramConnectionTemplate getConnectionTemplate(DiagramNodePart srcNode) {
        DiagramEmbeddedConnectionTemplate embeddedConn = srcNode.getDiagramNodeTemplate().getEmbeddedConnectionTemplate();
        if (embeddedConn != null && embeddedConn.getConnectionId().equalsIgnoreCase((String)this.connDef.getId().getContent())) {
            return embeddedConn;
        }
        List connTemplates = this.diagramPart.getConnectionTemplates();
        for (DiagramConnectionTemplate connTemplate : connTemplates) {
            if (!connTemplate.getConnectionId().equalsIgnoreCase((String)this.connDef.getId().getContent())) continue;
            return connTemplate;
        }
        return null;
    }
}

