/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;

public class SapphireDirectEditNodeFeature
extends AbstractDirectEditingFeature {
    public SapphireDirectEditNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        if (bo instanceof DiagramNodePart && ga instanceof Text) {
            return ((DiagramNodePart)bo).canEditLabel();
        }
        return false;
    }

    public String getInitialValue(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        DiagramNodePart nodePart = (DiagramNodePart)this.getBusinessObjectForPictogramElement(pe);
        return nodePart.getLabel();
    }

    public void setValue(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe.eContainer() instanceof Shape) {
            DiagramNodePart nodePart = (DiagramNodePart)this.getBusinessObjectForPictogramElement(pe);
            nodePart.setLabel(value);
            IModelElement nodeElement = nodePart.getLocalModelElement();
            Shape nodeShape = (Shape)pe.eContainer();
            for (Anchor anchor : nodeShape.getAnchors()) {
                for (Connection connection : Graphiti.getPeService().getAllConnections(anchor)) {
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection);
                    if (!(bo instanceof DiagramConnectionPart) || bo instanceof DiagramImplicitConnectionPart) continue;
                    DiagramConnectionPart connectionPart = (DiagramConnectionPart)bo;
                    IModelElement endpoint1 = connectionPart.getEndpoint1();
                    IModelElement endpoint2 = connectionPart.getEndpoint2();
                    if (!endpoint1.equals(nodeElement) && !endpoint2.equals(nodeElement)) continue;
                    connectionPart.removeModelListener();
                    connectionPart.getDiagramConnectionTemplate().removeModelListener();
                    if (endpoint1.equals(nodeElement)) {
                        connectionPart.resetEndpoint1();
                    } else if (endpoint2.equals(nodeElement)) {
                        connectionPart.resetEndpoint2();
                    }
                    connectionPart.addModelListener();
                    connectionPart.getDiagramConnectionTemplate().addModelListener();
                }
            }
        }
    }
}

