/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;

public class SapphireUpdateConnectionFeature
extends AbstractUpdateFeature {
    public SapphireUpdateConnectionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        return bo instanceof DiagramConnectionPart;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        String pictogramName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof Connection) {
            Connection c = (Connection)pictogramElement;
            for (ConnectionDecorator cd : c.getConnectionDecorators()) {
                if (!(cd.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)cd.getGraphicsAlgorithm();
                pictogramName = text.getValue();
            }
        }
        String businessName = null;
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof DiagramConnectionPart) {
            DiagramConnectionPart connPart = (DiagramConnectionPart)bo;
            businessName = connPart.getLabel();
        }
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.equals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)"Name is out of date");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        String businessName = null;
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramConnectionPart) {
            DiagramConnectionPart connPart = (DiagramConnectionPart)bo;
            businessName = connPart.getLabel();
        }
        if (pe instanceof Connection) {
            Connection c = (Connection)pe;
            for (ConnectionDecorator cd : c.getConnectionDecorators()) {
                if (!(cd.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)cd.getGraphicsAlgorithm();
                text.setValue(businessName);
                return true;
            }
        }
        return false;
    }
}

