/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.diagram.def.DecoratorPlacement;
import org.eclipse.sapphire.ui.diagram.def.IDiagramDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeProblemDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.ProblemDecoratorSize;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireDoubleClickNodeFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDiagramToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    private static final int SMALL_ERROR_DECORATOR_WIDTH = 7;
    private static final int SMALL_ERROR_DECORATOR_HEIGHT = 8;
    private static final int LARGE_ERROR_DECORATOR_WIDTH = 16;
    private static final int LARGE_ERROR_DECORATOR_HEIGHT = 16;

    public SapphireDiagramToolBehaviorProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        return null;
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        PictogramElement[] pes;
        PictogramElement[] pictogramElementArray = pes = context.getPictogramElements();
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            Object bo;
            PictogramElement pe = pictogramElementArray[n2];
            if (pe instanceof ContainerShape) {
                DiagramNodePart nodePart;
                bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
                if (bo instanceof DiagramNodePart && ((nodePart = (DiagramNodePart)bo).getDefaultActionHandler() != null || nodePart.canEditLabel())) {
                    SapphireDoubleClickNodeFeature dblClikFeature = new SapphireDoubleClickNodeFeature(this.getFeatureProvider(), (ISapphirePart)nodePart);
                    return dblClikFeature;
                }
            } else if (pe instanceof ConnectionDecorator && pe.getGraphicsAlgorithm() instanceof Text && (bo = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pe.eContainer())) instanceof DiagramConnectionPart) {
                SapphireDoubleClickNodeFeature dblClikFeature = new SapphireDoubleClickNodeFeature(this.getFeatureProvider(), (ISapphirePart)((DiagramConnectionPart)bo));
                return dblClikFeature;
            }
            ++n2;
        }
        return null;
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramNodePart) {
            ArrayList<IDecorator> decoratorList = new ArrayList<IDecorator>();
            DiagramNodePart nodePart = (DiagramNodePart)bo;
            if (((Boolean)nodePart.getProblemIndicatorDef().isShowDecorator().getContent()).booleanValue()) {
                this.addNodeProblemDecorator(pe, nodePart, decoratorList);
            }
            List imageDecorators = nodePart.getImageDecorators();
            for (IDiagramImageDecoratorDef imageDecorator : imageDecorators) {
                this.addNodeImageDecorator(pe, imageDecorator, decoratorList);
            }
            return decoratorList.toArray(new IDecorator[0]);
        }
        return super.getDecorators(pe);
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramNodePart && (name = ((DiagramNodePart)bo).getLabel()) != null && name.length() > 0) {
            return name;
        }
        return super.getToolTip(ga);
    }

    private void addNodeProblemDecorator(PictogramElement pe, DiagramNodePart nodePart, List<IDecorator> decoratorList) {
        IModelElement model = nodePart.getModelElement();
        IDiagramNodeProblemDecoratorDef decoratorDef = nodePart.getProblemIndicatorDef();
        Status status = model.validate();
        ImageDecorator imageRenderingDecorator = null;
        if (status.severity() != Status.Severity.OK) {
            if (status.severity() == Status.Severity.WARNING) {
                imageRenderingDecorator = decoratorDef.getSize().getContent() == ProblemDecoratorSize.SMALL ? new ImageDecorator("org.eclipse.sapphire.ui.swt.graphiti.warning") : new ImageDecorator("org.eclipse.graphiti.eclipse.warning");
            } else if (status.severity() == Status.Severity.ERROR) {
                imageRenderingDecorator = decoratorDef.getSize().getContent() == ProblemDecoratorSize.SMALL ? new ImageDecorator("org.eclipse.sapphire.ui.swt.graphiti.error") : new ImageDecorator("org.eclipse.graphiti.eclipse.error");
            }
        }
        if (imageRenderingDecorator != null) {
            int indicatorWidth = decoratorDef.getSize().getContent() == ProblemDecoratorSize.LARGE ? 16 : 7;
            int indicatorHeight = decoratorDef.getSize().getContent() == ProblemDecoratorSize.LARGE ? 16 : 8;
            Point pt = this.getDecoratorPosition(pe, (IDiagramDecoratorDef)decoratorDef, indicatorWidth, indicatorHeight);
            imageRenderingDecorator.setX(pt.getX());
            imageRenderingDecorator.setY(pt.getY());
            imageRenderingDecorator.setMessage(status.message());
            decoratorList.add((IDecorator)imageRenderingDecorator);
        }
    }

    private void addNodeImageDecorator(PictogramElement pe, IDiagramImageDecoratorDef imageDecoratorDef, List<IDecorator> decoratorList) {
        String imageId = (String)imageDecoratorDef.getImageId().getContent();
        if (imageId != null) {
            ImageDecorator imageRenderingDecorator = new ImageDecorator(imageId);
            org.eclipse.swt.graphics.Image image = GraphitiUi.getImageService().getImageForId(imageId);
            int imageWidth = image.getImageData().width;
            int imageHeight = image.getImageData().height;
            Point pt = this.getDecoratorPosition(pe, (IDiagramDecoratorDef)imageDecoratorDef, imageWidth, imageHeight);
            imageRenderingDecorator.setX(pt.getX());
            imageRenderingDecorator.setY(pt.getY());
            decoratorList.add((IDecorator)imageRenderingDecorator);
        }
    }

    private Point getDecoratorPosition(PictogramElement pe, IDiagramDecoratorDef decoratorDef, int decoratorWidth, int decoratorHeight) {
        GraphicsAlgorithm referencedGA = null;
        GraphicsAlgorithm text = null;
        ContainerShape containerShape = (ContainerShape)pe;
        EList children = containerShape.getChildren();
        for (Shape child : children) {
            GraphicsAlgorithm ga = child.getGraphicsAlgorithm();
            if (ga instanceof Image) {
                if (decoratorDef.getDecoratorPlacement().getContent() != DecoratorPlacement.IMAGE) continue;
                referencedGA = ga;
                break;
            }
            if (!(ga instanceof Text)) continue;
            if (decoratorDef.getDecoratorPlacement().getContent() == DecoratorPlacement.LABEL) {
                referencedGA = ga;
                break;
            }
            if (text != null) continue;
            text = (Text)ga;
        }
        if (referencedGA == null) {
            referencedGA = text;
        }
        if (referencedGA != null) {
            HorizontalAlignment horizontalAlign = (HorizontalAlignment)decoratorDef.getHorizontalAlignment().getContent();
            int offsetX = 0;
            int offsetY = 0;
            if (horizontalAlign == HorizontalAlignment.RIGHT) {
                offsetX = referencedGA.getWidth() - decoratorWidth;
                offsetX -= ((Integer)decoratorDef.getHorizontalMargin().getContent()).intValue();
            } else if (horizontalAlign == HorizontalAlignment.LEFT) {
                offsetX += ((Integer)decoratorDef.getHorizontalMargin().getContent()).intValue();
            } else if (horizontalAlign == HorizontalAlignment.CENTER) {
                offsetX = referencedGA.getWidth() - decoratorWidth >> 1;
            }
            VerticalAlignment verticalAlign = (VerticalAlignment)decoratorDef.getVerticalAlignment().getContent();
            if (verticalAlign == VerticalAlignment.BOTTOM) {
                offsetY = referencedGA.getHeight() - decoratorHeight;
                offsetY -= ((Integer)decoratorDef.getVerticalMargin().getContent()).intValue();
            } else if (verticalAlign == VerticalAlignment.TOP) {
                offsetY += ((Integer)decoratorDef.getVerticalMargin().getContent()).intValue();
            } else if (verticalAlign == VerticalAlignment.CENTER) {
                offsetY = (referencedGA.getHeight() - decoratorHeight) / 2;
            }
            return new Point(offsetX + referencedGA.getX(), offsetY + referencedGA.getY());
        }
        return new Point(0, 0);
    }
}

