/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.providers;

import java.util.List;
import org.eclipse.graphiti.dt.AbstractDiagramTypeProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeImageDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramImageProvider;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramSolver;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramToolBehaviorProvider;
import org.osgi.framework.Bundle;

public class SapphireDiagramTypeProvider
extends AbstractDiagramTypeProvider {
    private SapphireDiagramFeatureProvider featureProvider = new SapphireDiagramFeatureProvider((IDiagramTypeProvider)this, new SapphireDiagramSolver());
    private IToolBehaviorProvider[] toolBehaviorProviders;

    public SapphireDiagramTypeProvider() {
        this.setFeatureProvider((IFeatureProvider)this.featureProvider);
    }

    public void init(Diagram diagram, IDiagramEditor diagramEditor) {
        super.init(diagram, diagramEditor);
        SapphireDiagramEditorPagePart editorPart = ((SapphireDiagramEditor)diagramEditor).getPart();
        DiagramRenderingContext renderingCtx = new DiagramRenderingContext((ISapphirePart)editorPart, (SapphireDiagramEditor)diagramEditor, (GraphicsAlgorithmContainer)diagram);
        this.featureProvider.addRenderingContext((SapphirePart)editorPart, renderingCtx);
        ExtensionManager extManager = (ExtensionManager)GraphitiUi.getExtensionManager();
        IImageProvider[] imageProviders = extManager.getImageProviders();
        SapphireDiagramImageProvider sapphireImageProvider = null;
        IImageProvider[] iImageProviderArray = imageProviders;
        int n = imageProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IImageProvider imageProvider = iImageProviderArray[n2];
            if (imageProvider instanceof SapphireDiagramImageProvider) {
                sapphireImageProvider = (SapphireDiagramImageProvider)imageProvider;
                break;
            }
            ++n2;
        }
        if (sapphireImageProvider != null) {
            SapphireDiagramEditorPagePart diagramPart = this.getDiagramPart();
            List diagramImages = diagramPart.getImageDecorators();
            for (IDiagramImageChoice imageChoice : diagramImages) {
                this.registerImage(sapphireImageProvider, imageChoice);
            }
            List nodeTemplates = diagramPart.getNodeTemplates();
            for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
                IDiagramImageChoice toolImage;
                IDiagramNodeDef nodeDef = nodeTemplate.getDefinition();
                IDiagramNodeImageDef imageDef = (IDiagramNodeImageDef)nodeDef.getImage().element();
                if (imageDef != null) {
                    ModelElementList images = imageDef.getPossibleImages();
                    for (IDiagramImageChoice imageChoice : images) {
                        this.registerImage(sapphireImageProvider, imageChoice);
                    }
                }
                if ((toolImage = nodeTemplate.getToolPaletteImage()) == null) continue;
                this.registerImage(sapphireImageProvider, toolImage);
            }
            List connDefs = diagramPart.getDiagramConnectionDefs();
            for (IDiagramConnectionDef connDef : connDefs) {
                IDiagramImageChoice image = (IDiagramImageChoice)connDef.getToolPaletteImage().element();
                if (image == null) continue;
                this.registerImage(sapphireImageProvider, image);
            }
        }
    }

    public IToolBehaviorProvider[] getAvailableToolBehaviorProviders() {
        if (this.toolBehaviorProviders == null) {
            this.toolBehaviorProviders = new IToolBehaviorProvider[]{new SapphireDiagramToolBehaviorProvider((IDiagramTypeProvider)this)};
        }
        return this.toolBehaviorProviders;
    }

    private void registerImage(SapphireDiagramImageProvider sapphireImageProvider, IDiagramImageChoice imageChoice) {
        ISapphireUiDef uiDef = (ISapphireUiDef)imageChoice.nearest(ISapphireUiDef.class);
        String imageId = (String)imageChoice.getImageId().getContent();
        String imagePath = (String)imageChoice.getImagePath().getContent();
        String bundleId = this.resolveImageBundle(uiDef, imagePath);
        if (bundleId != null) {
            sapphireImageProvider.setPluginId(bundleId);
        }
        if (imageId != null && imagePath != null && sapphireImageProvider.getImageFilePath(imageId) == null) {
            sapphireImageProvider.registerImage(imageId, imagePath);
        }
    }

    private String resolveImageBundle(ISapphireUiDef def, String imagePath) {
        Bundle bundle = (Bundle)def.adapt(Bundle.class);
        if (bundle != null) {
            return bundle.getSymbolicName();
        }
        return null;
    }

    private SapphireDiagramEditorPagePart getDiagramPart() {
        SapphireDiagramEditor diagramEditor = (SapphireDiagramEditor)this.getDiagramEditor();
        return diagramEditor.getPart();
    }
}

