/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public final class StandardXmlElementBindingImpl
extends LayeredElementBindingImpl {
    private XmlPath path;
    private QName[] xmlElementNames;
    private ModelElementType[] modelElementTypes;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        try {
            XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.getAnnotation(XmlElementBinding.class);
            XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)element.resource()).getXmlNamespaceResolver();
            if (xmlElementBindingAnnotation == null) {
                XmlBinding xmlBindingAnnotation = (XmlBinding)property.getAnnotation(XmlBinding.class);
                if (xmlBindingAnnotation != null && property.getAllPossibleTypes().size() == 1) {
                    String path = xmlBindingAnnotation.path();
                    int slashIndex = path.lastIndexOf(47);
                    if (slashIndex == -1) {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName(path, xmlNamespaceResolver)};
                        this.modelElementTypes = new ModelElementType[]{property.getType()};
                    } else if (slashIndex > 0 && slashIndex < path.length() - 1) {
                        this.path = new XmlPath(path.substring(0, slashIndex), xmlNamespaceResolver);
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName(path.substring(slashIndex + 1), xmlNamespaceResolver)};
                        this.modelElementTypes = new ModelElementType[]{property.getType()};
                    }
                }
                if (this.xmlElementNames == null) {
                    this.path = new XmlPath(property.getName(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
                    List types = property.getAllPossibleTypes();
                    this.modelElementTypes = types.toArray(new ModelElementType[types.size()]);
                    this.xmlElementNames = new QName[this.modelElementTypes.length];
                    int i = 0;
                    while (i < this.modelElementTypes.length) {
                        this.xmlElementNames[i] = XmlUtil.createQualifiedName(this.modelElementTypes[i].getSimpleName().substring(1), xmlNamespaceResolver);
                        ++i;
                    }
                }
            } else {
                if (xmlElementBindingAnnotation.path().length() > 0) {
                    this.path = new XmlPath(xmlElementBindingAnnotation.path(), xmlNamespaceResolver);
                }
                XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
                this.xmlElementNames = new QName[mappings.length];
                this.modelElementTypes = new ModelElementType[mappings.length];
                int i = 0;
                while (i < mappings.length) {
                    XmlElementBinding.Mapping mapping = mappings[i];
                    String mappingElementName = mapping.element().trim();
                    if (mappingElementName.length() == 0) {
                        throw new RuntimeException(Resources.mustSpecifyElementNameMsg);
                    }
                    this.xmlElementNames[i] = XmlUtil.createQualifiedName(mappingElementName, xmlNamespaceResolver);
                    this.modelElementTypes[i] = ModelElementType.getModelElementType(mapping.type());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failure, (Object[])new Object[]{element.getModelElementType().getSimpleName(), property.getName(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    public ModelElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName(xmlElement.getDomNode());
        String xmlElementNamespace = xmlElementName.getNamespaceURI();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (XmlUtil.equal(this.xmlElementNames[i], xmlElementName, xmlElementNamespace)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(false);
        if (parent != null) {
            if (this.path != null) {
                parent = (XmlElement)parent.getChildNode(this.path, false);
            }
            if (parent != null) {
                for (XmlElement element : parent.getChildElements()) {
                    QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                    if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                    return element;
                }
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ModelElementType type) {
        QName xmlElementName;
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(true);
        if (this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, true);
        }
        if ((xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.modelElementTypes, (Object)type)]).getNamespaceURI().equals("")) {
            xmlElementName = new QName(parent.getNamespace(), xmlElementName.getLocalPart());
        }
        return parent.getChildElement(xmlElementName, true);
    }

    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    public void remove() {
        XmlElement base = ((XmlResource)this.element().resource()).getXmlElement(false);
        if (base != null) {
            XmlElement parent = base;
            if (this.path != null) {
                parent = (XmlElement)parent.getChildNode(this.path, false);
            }
            if (parent != null) {
                for (XmlElement element : parent.getChildElements()) {
                    QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                    if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                    element.remove();
                }
                if (parent != base && parent.isEmpty()) {
                    base.removeChildNode(this.path);
                }
            }
        }
    }

    public boolean removable() {
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String failure;
        public static String mustSpecifyElementNameMsg;

        static {
            Resources.initializeMessages((String)StandardXmlElementBindingImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

