/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;

public final class XmlElementDefinitionByReference
extends XmlElementDefinition {
    private QName contentModelName = null;
    private boolean contentModelResolved = false;

    private XmlElementDefinitionByReference(XmlDocumentSchema schema, QName elementName, int minOccur, int maxOccur) {
        super(schema, elementName, null, minOccur, maxOccur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName getContentModelName() {
        boolean contentModelResolveNeeded;
        XmlElementDefinitionByReference xmlElementDefinitionByReference = this;
        synchronized (xmlElementDefinitionByReference) {
            contentModelResolveNeeded = !this.contentModelResolved;
        }
        if (contentModelResolveNeeded) {
            XmlElementDefinition refElement;
            XmlDocumentSchema refSchema;
            QName contentModelName = null;
            QName ref = this.getName();
            String namespace = ref.getNamespaceURI();
            if (namespace == null || namespace.length() == 0) {
                refSchema = this.getSchema();
            } else {
                String refSchemaLocation = this.getSchema().getSchemaLocation(namespace);
                refSchema = XmlDocumentSchemasCache.getSchema(refSchemaLocation);
            }
            if (refSchema != null && (refElement = refSchema.getElement(ref.getLocalPart())) != null) {
                contentModelName = refElement.getContentModelName();
            }
            XmlElementDefinitionByReference xmlElementDefinitionByReference2 = this;
            synchronized (xmlElementDefinitionByReference2) {
                if (!this.contentModelResolved) {
                    this.contentModelName = contentModelName;
                    this.contentModelResolved = true;
                }
            }
        }
        return this.contentModelName;
    }

    private XmlElementDefinition getElementInGroup(QName childElementName) {
        List<XmlElementDefinition> list;
        XmlElementDefinition definition = this.getSchema().getElement(this.getName().getLocalPart());
        if (definition != null && definition.isAbstract() && (list = definition.getSubstitutionList()) != null && list.size() > 0) {
            for (XmlElementDefinition subGroup : list) {
                if (!subGroup.getName().equals(childElementName)) continue;
                return subGroup;
            }
        }
        return null;
    }

    public XmlContentModel findChildElementContentModel(QName childElementName) {
        XmlElementDefinition subGroup;
        XmlContentModel model = super.findChildElementContentModel(childElementName);
        if (model == null && (subGroup = this.getElementInGroup(childElementName)) != null) {
            return subGroup.getContentModel();
        }
        return model;
    }

    protected boolean sameElementName(QName qname) {
        XmlElementDefinition subGroup;
        boolean isSame = super.sameElementName(qname);
        if (!isSame && (subGroup = this.getElementInGroup(qname)) != null) {
            return true;
        }
        return isSame;
    }

    /* synthetic */ XmlElementDefinitionByReference(XmlDocumentSchema xmlDocumentSchema, QName qName, int n, int n2, XmlElementDefinitionByReference xmlElementDefinitionByReference) {
        this(xmlDocumentSchema, qName, n, n2);
    }

    public static final class Factory
    extends XmlElementDefinition.Factory {
        public QName getContentModelName() {
            throw new UnsupportedOperationException();
        }

        public void setContentModelName(QName contentModelName) {
            throw new UnsupportedOperationException();
        }

        public void setContentModelName(String contentModelName) {
            throw new UnsupportedOperationException();
        }

        public XmlContentModel create(XmlDocumentSchema schema) {
            return new XmlElementDefinitionByReference(schema, this.elementName, this.minOccur, this.maxOccur, null);
        }
    }
}

