/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.templates.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.templates.core.ITemplateOperation;
import com.liferay.ide.eclipse.templates.core.TemplateModel;
import com.liferay.ide.eclipse.templates.core.TemplatesCore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class TemplateOperation
implements ITemplateOperation {
    protected VelocityContext context;
    protected TemplateModel model;
    protected StringBuffer outputBuffer;
    protected IFile outputFile;
    protected Template template;

    public TemplateOperation(TemplateModel model) {
        this.model = model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canExecute() {
        try {
            if (this.outputFile == null && this.outputBuffer == null || this.model == null || this.getTemplate() == null) {
                return false;
            }
            Object[] names = this.model.getRequiredVarNames();
            if (!CoreUtil.isNullOrEmpty((Object[])names)) {
                Object[] objectArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    Object name = objectArray[n2];
                    if (!this.getContext().containsKey(name)) {
                        TemplatesCore.logError("Could not execute template operation: context var " + (String)name + " not found.");
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void execute(IProgressMonitor monitor) throws Exception {
        if (!this.canExecute()) {
            return;
        }
        StringWriter writer = new StringWriter();
        this.getTemplate().merge((Context)this.getContext(), (Writer)writer);
        String result = writer.toString();
        if (this.outputFile != null) {
            if (this.outputFile.exists()) {
                this.outputFile.setContents((InputStream)new ByteArrayInputStream(result.getBytes()), true, true, monitor);
            } else {
                this.outputFile.create((InputStream)new ByteArrayInputStream(result.getBytes()), true, monitor);
            }
        } else if (this.outputBuffer != null) {
            this.outputBuffer.delete(0, this.outputBuffer.length());
            this.outputBuffer.append(result);
        }
    }

    public VelocityContext getContext() {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setOutputBuffer(StringBuffer buffer) {
        this.outputBuffer = buffer;
    }

    public void setOutputFile(IFile file) {
        this.outputFile = file;
    }

    protected VelocityContext createContext() {
        return new VelocityContext();
    }

    protected Template getTemplate() throws Exception {
        if (this.model == null) {
            return null;
        }
        if (this.template == null) {
            this.template = this.model.getEngine().getTemplate(this.model.getResource());
        }
        return this.template;
    }
}

