/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.templates.core;

import com.liferay.ide.eclipse.templates.core.ITemplateOperation;
import com.liferay.ide.eclipse.templates.core.TemplateModel;
import com.liferay.ide.eclipse.templates.core.TemplateOperation;
import com.liferay.ide.eclipse.templates.core.TemplateVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TemplatesCore
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.liferay.ide.eclipse.templates.core";
    private static TemplatesCore plugin;
    private static Map<String, TemplateModel> pluginModels;
    private static Map<String, TemplateModel> templateModels;
    private static IConfigurationElement[] tplDefinitionElements;

    static {
        pluginModels = new HashMap<String, TemplateModel>();
        templateModels = new HashMap<String, TemplateModel>();
    }

    public static IStatus createErrorStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static TemplatesCore getDefault() {
        return plugin;
    }

    public static ITemplateOperation getTemplateOperation(String templateId) {
        return TemplatesCore.getTemplateOperation(templateId, null);
    }

    public static ITemplateOperation getTemplateOperation(String templateId, Object context) {
        TemplateModel model = TemplatesCore.getTemplateModel(templateId);
        return new TemplateOperation(model);
    }

    public static void logError(Exception e) {
        TemplatesCore.getDefault().getLog().log(TemplatesCore.createErrorStatus(e));
    }

    public static void logError(String msg) {
        TemplatesCore.getDefault().getLog().log(TemplatesCore.createErrorStatus(msg));
    }

    private static TemplateModel createPluginModel(IConfigurationElement element, String pluginName) {
        TemplateModel templateModel = null;
        try {
            IConfigurationElement[] items;
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String resource = element.getAttribute("resource");
            String templateFolder = null;
            ArrayList<TemplateVariable> paramList = new ArrayList<TemplateVariable>();
            IConfigurationElement[] iConfigurationElementArray = items = ((IExtension)element.getParent()).getConfigurationElements();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement item = iConfigurationElementArray[n2];
                if ("templatesFolder".equals(item.getName())) {
                    templateFolder = item.getAttribute("path");
                }
                if ("templateVariable".equals(item.getName())) {
                    String paramName = item.getAttribute("name");
                    String reqVal = item.getAttribute("required");
                    paramList.add(new TemplateVariable(paramName, reqVal));
                }
                ++n2;
            }
            VelocityEngine velocityEngine = new VelocityEngine();
            templateModel = new TemplateModel(pluginName, id, name, resource, templateFolder, velocityEngine, paramList.toArray(new TemplateVariable[0]));
        }
        catch (Exception e) {
            TemplatesCore.logError(e);
        }
        return templateModel;
    }

    private static TemplateModel getTemplateModel(String templateId) {
        if (templateId == null) {
            return null;
        }
        TemplateModel model = templateModels.get(templateId);
        if (model == null) {
            IConfigurationElement element = TemplatesCore.getTplDefinitionElement(templateId);
            String pluginName = element.getContributor().getName();
            TemplateModel pluginModel = pluginModels.get(pluginName);
            if (pluginModel == null) {
                pluginModel = TemplatesCore.createPluginModel(element, pluginName);
                try {
                    TemplatesCore.initializeModel(pluginModel);
                }
                catch (Exception e) {
                    TemplatesCore.logError(e);
                    pluginModel = null;
                }
                if (pluginModel != null) {
                    pluginModels.put(pluginName, pluginModel);
                }
            }
            if (pluginModel != null) {
                templateModels.put(templateId, pluginModel);
                model = pluginModel;
            }
        }
        return model;
    }

    private static IConfigurationElement getTplDefinitionElement(String templateId) {
        IConfigurationElement[] elements;
        if (templateId == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = TemplatesCore.getTplDefinitionElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("template".equals(element.getName()) && templateId.equals(element.getAttribute("id"))) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IConfigurationElement[] getTplDefinitionElements() {
        if (tplDefinitionElements == null) {
            tplDefinitionElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.templates.core.templateDefinition");
        }
        return tplDefinitionElements;
    }

    private static void initializeModel(TemplateModel templateModel) throws Exception {
        VelocityEngine engine = templateModel.getEngine();
        engine.setProperty("resource.loader", (Object)"url");
        engine.setProperty("url.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.URLResourceLoader");
        URL loaderRoot = Platform.getBundle((String)templateModel.bundleId).getEntry(templateModel.templateFolder);
        engine.setProperty("url.resource.loader.root", (Object)loaderRoot.toURI().toASCIIString());
        engine.setProperty("url.resource.loader.cache", (Object)true);
        templateModel.getEngine().init();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

