/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.core.facet;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.FileUtil;
import com.liferay.ide.eclipse.project.core.facet.PluginFacetInstall;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class LayoutTplPluginFacetInstall
extends PluginFacetInstall {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFolder libFolder;
        Object[] libFiles;
        super.execute(project, fv, config, monitor);
        IDataModel model = (IDataModel)config;
        IDataModel masterModel = (IDataModel)model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (masterModel != null && masterModel.getBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION")) {
            SDK sdk = this.getSDK();
            String layoutTplName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.LAYOUTTPL_NAME");
            String displayName = this.masterModel.getStringProperty("IPluginProjectCreationPropertiesNew.DISPLAY_NAME");
            Map appServerProperties = ServerUtil.configureAppServerProperties((IProject)project);
            IPath newLayoutTplPath = sdk.createNewLayoutTplProject(layoutTplName, displayName, appServerProperties);
            this.processNewFiles(newLayoutTplPath.append(String.valueOf(layoutTplName) + "-layouttpl"), false);
            FileUtil.deleteDir((File)newLayoutTplPath.toFile(), (boolean)true);
        } else {
            this.setupDefaultOutputLocation();
        }
        this.removeUnneededClasspathEntries();
        IResource libRes = project.findMember("docroot/WEB-INF/lib");
        if (libRes != null && libRes.exists() && CoreUtil.isNullOrEmpty((Object[])(libFiles = (libFolder = (IFolder)libRes).members(true)))) {
            libRes.delete(true, monitor);
        }
        this.project.refreshLocal(2, monitor);
    }

    protected void removeUnneededClasspathEntries() {
        IFacetedProjectWorkingCopy facetedProject = this.getFacetedProject();
        IJavaProject javaProject = JavaCore.create((IProject)facetedProject.getProject());
        try {
            IClasspathEntry[] existingClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = existingClasspath;
            int n = existingClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!(entry.getEntryKind() == 3 || entry.getEntryKind() == 5 && ((path = entry.getPath().toPortableString()).contains("org.eclipse.jdt.launching.JRE_CONTAINER") || path.contains("org.eclipse.jst.j2ee.internal.web.container") || path.contains("org.eclipse.jst.j2ee.internal.module.container")))) {
                    newClasspath.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[0]), null);
            IResource sourceFolder = javaProject.getProject().findMember("docroot/WEB-INF/src");
            if (sourceFolder.exists()) {
                sourceFolder.delete(true, null);
            }
        }
        catch (Exception exception) {}
    }

    protected boolean shouldInstallPluginLibraryDelegate() {
        return false;
    }
}

