/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.core.operation;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.layouttpl.core.LayoutTplCore;
import com.liferay.ide.eclipse.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.eclipse.layouttpl.core.operation.LayoutTplDescriptorHelper;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;

public class NewLayoutTplDataModelProvider
extends ArtifactEditOperationDataModelProvider
implements INewLayoutTplDataModelProperties {
    protected TemplateContextType contextType;
    protected boolean ignoreLayoutOptionPropertySet = false;
    protected TemplateStore templateStore;

    public NewLayoutTplDataModelProvider(TemplateStore templateStore, TemplateContextType contextType) {
        this.templateStore = templateStore;
        this.contextType = contextType;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME".equals(propertyName)) {
            return "New Template";
        }
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(propertyName)) {
            String name = this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME");
            if (!CoreUtil.isNullOrEmpty((String)name)) {
                return name.replaceAll("[^a-zA-Z0-9]+", "").toLowerCase();
            }
        } else {
            if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".tpl";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".wap.tpl";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".png";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_IMAGE_BLANK_COLUMN".equals(propertyName)) {
                return true;
            }
            if ("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN".equals(propertyName)) {
                return false;
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_BLANK_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED");
        return propertyNames;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean isLayoutOption = false;
        int i = 0;
        while (i < LAYOUT_PROPERTIES.length) {
            if (LAYOUT_PROPERTIES[i].equals(propertyName)) {
                isLayoutOption = true;
                break;
            }
            ++i;
        }
        if (isLayoutOption && !this.ignoreLayoutOptionPropertySet) {
            this.ignoreLayoutOptionPropertySet = true;
            i = 0;
            while (i < LAYOUT_PROPERTIES.length) {
                this.setBooleanProperty(LAYOUT_PROPERTIES[i], false);
                ++i;
            }
            this.setProperty(propertyName, propertyValue);
            this.ignoreLayoutOptionPropertySet = false;
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        IFile thumbnailFile;
        IProject targetProject;
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(propertyName)) {
            LayoutTplDescriptorHelper helper = new LayoutTplDescriptorHelper(this.getTargetProject());
            if (helper.hasTemplateId(this.getStringProperty(propertyName))) {
                return LayoutTplCore.createErrorStatus("Template id already exists in project.");
            }
            String idValue = String.valueOf(this.getStringProperty(propertyName)) + "z";
            if (CoreUtil.isNullOrEmpty((String)idValue)) {
                return super.validate(propertyName);
            }
            IStatus status = JavaConventions.validateFieldName((String)idValue, (String)"1.5", (String)"1.5");
            if (!status.isOK()) {
                return LayoutTplCore.createErrorStatus("Template id is invalid.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE".equals(propertyName)) {
            IFile templateFile;
            IProject targetProject2 = this.getTargetProject();
            if (targetProject2 != null && (templateFile = CoreUtil.getDocroot((IProject)targetProject2).getFile(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE"))).exists()) {
                return LayoutTplCore.createWarningStatus("Template file already exists and will be overwritten.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE".equals(propertyName)) {
            IFile wapTemplateFile;
            IProject targetProject3 = this.getTargetProject();
            if (targetProject3 != null && (wapTemplateFile = CoreUtil.getDocroot((IProject)targetProject3).getFile(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE"))).exists()) {
                return LayoutTplCore.createWarningStatus("WAP template file already exists and will be overwritten.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE".equals(propertyName) && (targetProject = this.getTargetProject()) != null && (thumbnailFile = CoreUtil.getDocroot((IProject)targetProject).getFile(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE"))).exists()) {
            return LayoutTplCore.createWarningStatus("Thumbnail file already exists and will be overwritten.");
        }
        return super.validate(propertyName);
    }

    protected IStatus validateListItems(String propertyName) {
        List itemsList;
        Object items = this.getProperty(propertyName);
        if (items instanceof List && (itemsList = (List)items).size() > 0) {
            return Status.OK_STATUS;
        }
        return LayoutTplCore.createErrorStatus("Need to specify at least one item.");
    }
}

