/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui;

import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Bundle;

public class PluginProjectDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static ImageDescriptor EXT;
    private static final String EXT_FACET = "liferay.ext";
    private static ImageDescriptor HOOK;
    private static final String HOOK_FACET = "liferay.hook";
    private static final String ICON_DIR = "icons/ovr";
    private static ImageDescriptor LAYOUTTPL;
    private static final String LAYOUTTPL_FACET = "liferay.layouttpl";
    private static ImageDescriptor PORTLET;
    private static final String PORTLET_FACET = "liferay.portlet";
    private static ImageDescriptor THEME;
    private static final String THEME_FACET = "liferay.theme";

    private static ImageDescriptor getExt() {
        if (EXT == null) {
            EXT = PluginProjectDecorator.getImageDescriptor("liferay_ovr");
        }
        return EXT;
    }

    private static ImageDescriptor getHook() {
        if (HOOK == null) {
            HOOK = PluginProjectDecorator.getImageDescriptor("liferay_ovr");
        }
        return HOOK;
    }

    private static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        if (key != null) {
            String gif = "/" + key + ".png";
            IPath path = new Path(ICON_DIR).append(gif);
            URL gifImageURL = FileLocator.find((Bundle)Platform.getBundle((String)"com.liferay.ide.eclipse.project.ui"), (IPath)path, null);
            if (gifImageURL != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
            }
        }
        return imageDescriptor;
    }

    private static ImageDescriptor getLayoutTpl() {
        if (LAYOUTTPL == null) {
            LAYOUTTPL = PluginProjectDecorator.getImageDescriptor("liferay_ovr");
        }
        return LAYOUTTPL;
    }

    private static ImageDescriptor getPortlet() {
        if (PORTLET == null) {
            PORTLET = PluginProjectDecorator.getImageDescriptor("liferay_ovr");
        }
        return PORTLET;
    }

    private static ImageDescriptor getTheme() {
        if (THEME == null) {
            THEME = PluginProjectDecorator.getImageDescriptor("liferay_ovr");
        }
        return THEME;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IProject) {
            DecorationContext ctx = (DecorationContext)decoration.getDecorationContext();
            ctx.putProperty("org.eclipse.jface.viewers.IDecoration.disableReplace", (Object)true);
            IProject project = (IProject)element;
            ImageDescriptor overlay = null;
            if (this.hasFacet(project, PORTLET_FACET)) {
                overlay = PluginProjectDecorator.getPortlet();
            } else if (this.hasFacet(project, HOOK_FACET)) {
                overlay = PluginProjectDecorator.getHook();
            } else if (this.hasFacet(project, EXT_FACET)) {
                overlay = PluginProjectDecorator.getExt();
            } else if (this.hasFacet(project, LAYOUTTPL_FACET)) {
                overlay = PluginProjectDecorator.getLayoutTpl();
            } else if (this.hasFacet(project, THEME_FACET)) {
                overlay = PluginProjectDecorator.getTheme();
            }
            if (overlay != null) {
                decoration.addOverlay(overlay);
            }
        }
    }

    private boolean hasFacet(IProject project, String facet) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facet);
        }
        catch (CoreException e) {
            ProjectUIPlugin.logError((Exception)((Object)e));
            return false;
        }
    }
}

