/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.action;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.IProjectDefinition;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.project.ui.action.ImportLiferayProjectWizardAction;
import com.liferay.ide.eclipse.ui.action.NewWizardAction;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class NewPluginProjectDropDownAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    protected static final String PL_NEW = "newWizards";
    protected static final String TAG_CLASS = "class";
    protected static final String TAG_NAME = "name";
    protected static final String TAG_PARAMETER = "parameter";
    protected static final String TAG_VALUE = "value";
    protected static final String TAG_WIZARD = "wizard";
    protected Menu fMenu = null;
    protected Shell fWizardShell;

    public NewPluginProjectDropDownAction() {
        this.setMenuCreator(this);
    }

    public void dispose() {
    }

    public NewWizardAction[] getNewProjectActions() {
        ArrayList<NewWizardAction> containers = new ArrayList<NewWizardAction>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_WIZARD) && this.isProjectWizard(element, this.getTypeAttribute())) {
                    containers.add(new NewWizardAction(element));
                    IProjectDefinition[] projectDefinitions = ProjectCorePlugin.getProjectDefinitions();
                    List<IProjectDefinition> projectDefList = Arrays.asList(projectDefinitions);
                    Collections.sort(projectDefList, new ProjectDefComparator());
                    IProjectDefinition[] iProjectDefinitionArray = projectDefinitions;
                    int n3 = projectDefinitions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProjectDefinition projectDef = iProjectDefinitionArray[n4];
                        NewWizardAction wizardAction = new NewWizardAction(element);
                        wizardAction.setProjectType(projectDef.getFacetId());
                        if (projectDef != null) {
                            wizardAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)ProjectUIPlugin.getDefault().getBundle().getEntry("/icons/n16/" + projectDef.getShortName() + "_new.png")));
                            wizardAction.setText(wizardAction.getText().replaceAll("Liferay Plugin", String.valueOf(projectDef.getDisplayName()) + " Plugin"));
                        }
                        containers.add(wizardAction);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        Object[] actions = containers.toArray(new NewWizardAction[containers.size()]);
        Arrays.sort(actions);
        return actions;
    }

    public NewWizardAction[] getExtraProjectActions() {
        ArrayList<NewWizardAction> containers = new ArrayList<NewWizardAction>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_WIZARD) && this.isProjectWizard(element, this.getExtraTypeAttribute())) {
                    containers.add(new NewWizardAction(element));
                }
                ++n2;
            }
        }
        Object[] actions = containers.toArray(new NewWizardAction[containers.size()]);
        Arrays.sort(actions);
        return actions;
    }

    public Action getDefaultAction() {
        NewWizardAction[] actions = this.getNewProjectActions();
        if (actions.length > 0) {
            return actions[0];
        }
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu == null) {
            NewWizardAction[] extraActions;
            this.fMenu = new Menu(parent);
            NewWizardAction[] actions = this.getNewProjectActions();
            actions[0].setShell(this.fWizardShell);
            ActionContributionItem item = new ActionContributionItem((IAction)actions[0]);
            item.fill(this.fMenu, -1);
            new Separator().fill(this.fMenu, -1);
            ImportLiferayProjectWizardAction importAction = new ImportLiferayProjectWizardAction();
            importAction.setShell(this.fWizardShell);
            item = new ActionContributionItem((IAction)importAction);
            item.fill(this.fMenu, -1);
            NewWizardAction[] newWizardActionArray = extraActions = this.getExtraProjectActions();
            int n = extraActions.length;
            int n2 = 0;
            while (n2 < n) {
                NewWizardAction extraAction = newWizardActionArray[n2];
                extraAction.setShell(this.fWizardShell);
                ActionContributionItem extraItem = new ActionContributionItem((IAction)extraAction);
                extraItem.fill(this.fMenu, -1);
                ++n2;
            }
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWizardShell = window.getShell();
    }

    public void run(IAction action) {
        this.getDefaultAction().run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private boolean isProjectWizard(IConfigurationElement element, String typeAttribute) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (!CoreUtil.isNullOrEmpty((String)typeAttribute) && classElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = classElements;
            int n = classElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] paramElements;
                IConfigurationElement classElement = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(TAG_PARAMETER);
                int n3 = paramElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                    if (typeAttribute.equals(paramElement.getAttribute(TAG_NAME))) {
                        return Boolean.valueOf(paramElement.getAttribute(TAG_VALUE));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return Boolean.valueOf(element.getAttribute(this.getTypeAttribute())) != false;
    }

    protected String getExtraTypeAttribute() {
        return "liferay_extra_project";
    }

    protected String getTypeAttribute() {
        return "liferay_project";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProjectDefComparator
    implements Comparator<IProjectDefinition> {
        private ProjectDefComparator() {
        }

        @Override
        public int compare(IProjectDefinition o1, IProjectDefinition o2) {
            int index2;
            int index1 = o1.getMenuIndex();
            return index1 < (index2 = o2.getMenuIndex()) ? -1 : (index1 > index2 ? 1 : 0);
        }
    }
}

