/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.dialog;

import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class LiferayProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer fTableViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private ViewerFilter fFilter;

    public LiferayProjectSelectionDialog(Shell parentShell, ViewerFilter filter) {
        super(parentShell);
        this.setTitle("Project Selection");
        this.setMessage("Select project");
        this.fFilter = filter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.fTableViewer = new TableViewer(composite, 2816);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LiferayProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LiferayProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new LiferayJavaElementContentProvider());
        this.fTableViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTableViewer.getControl().setFont(font);
        this.updateFilter(true);
        IJavaModel input = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.fTableViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus((IStatus)new Status(4, "com.liferay.ide.eclipse.ui", ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus((IStatus)new Status(0, "com.liferay.ide.eclipse.ui", ""));
            this.setSelectionResult(objects);
        }
    }

    protected void updateFilter(boolean selected) {
        if (this.fFilter == null) {
            return;
        }
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
    }

    protected void computeResult() {
    }

    class LiferayJavaElementContentProvider
    extends StandardJavaElementContentProvider {
        LiferayJavaElementContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IJavaModel) {
                IJavaModel model = (IJavaModel)element;
                HashSet<IJavaProject> set = new HashSet<IJavaProject>();
                try {
                    IJavaProject[] projects = model.getJavaProjects();
                    int i = 0;
                    while (i < projects.length) {
                        if (ProjectUtil.isLiferayProject((IProject)projects[i].getProject())) {
                            set.add(projects[i]);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return set.toArray();
            }
            return super.getChildren(element);
        }
    }
}

