/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.IPortletFramework;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.project.ui.IPortletFrameworkDelegate;
import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.project.ui.wizard.NewPluginProjectWizard;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import com.liferay.ide.eclipse.ui.util.UIUtil;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jst.j2ee.internal.wizard.J2EEComponentFacetCreationWizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class NewPortletPluginProjectPage
extends J2EEComponentFacetCreationWizardPage
implements IPluginProjectDataModelProperties {
    protected Button[] frameworkButtons;
    protected Composite[] optionsComposites;
    protected Button pluginFragmentButton;

    public NewPortletPluginProjectPage(NewPluginProjectWizard wizard, IDataModel model) {
        super(model, "advanced.page");
        this.setWizard((IWizard)wizard);
        this.setImageDescriptor(wizard.getDefaultPageImageDescriptor());
        this.setTitle("Liferay Portlet Plugin Project");
        this.setDescription("Choose from available portlet frameworks depending on which technology is most appropriate for this project.");
    }

    public boolean canFlipToNextPage() {
        return this.getModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_ENABLED");
    }

    public IPortletFramework getSelectedPortletFramework() {
        IPortletFramework retval = null;
        if (!CoreUtil.isNullOrEmpty((Object[])this.frameworkButtons)) {
            Button[] buttonArray = this.frameworkButtons;
            int n = this.frameworkButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button templateButton = buttonArray[n2];
                if (templateButton.getSelection()) {
                    retval = (IPortletFramework)templateButton.getData();
                }
                ++n2;
            }
        }
        return retval;
    }

    protected void createFrameworkGroup(Composite parent) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)"Select portlet framework", (int)2);
        GridData layoutData = new GridData(4, 128, true, false, 2, 1);
        layoutData.widthHint = 500;
        group.setLayoutData((Object)layoutData);
        ((GridLayout)group.getLayout()).verticalSpacing = 10;
        Object[] portletFrameworks = ProjectCorePlugin.getPortletFrameworks();
        if (!CoreUtil.isNullOrEmpty((Object[])portletFrameworks)) {
            ArrayList<Button> buttons = new ArrayList<Button>();
            Object[] objectArray = portletFrameworks;
            int n = portletFrameworks.length;
            int n2 = 0;
            while (n2 < n) {
                Object framework = objectArray[n2];
                IPortletFrameworkDelegate delegate = ProjectUIPlugin.getPortletFrameworkDelegate(framework.getId());
                String iconUrl = null;
                String bundleId = null;
                if (delegate != null) {
                    iconUrl = delegate.getIconUrl();
                    bundleId = delegate.getBundleId();
                } else {
                    iconUrl = "icons/e16/jsp-template.png";
                    bundleId = "com.liferay.ide.eclipse.project.ui";
                }
                Button templateButton = SWTUtil.createRadioButton((Composite)group, (String)framework.getDisplayName(), (Image)UIUtil.getPluginImageDescriptor((String)bundleId, (String)iconUrl).createImage(), (boolean)false, (int)1);
                templateButton.setData(framework);
                ((GridData)templateButton.getLayoutData()).verticalAlignment = 128;
                templateButton.addSelectionListener((SelectionListener)new SelectionAdapter((IPortletFramework)framework, delegate){
                    private final /* synthetic */ IPortletFramework val$framework;
                    private final /* synthetic */ IPortletFrameworkDelegate val$delegate;
                    {
                        this.val$framework = iPortletFramework;
                        this.val$delegate = iPortletFrameworkDelegate;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        NewPortletPluginProjectPage.this.getDataModel().setProperty("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK", (Object)this.val$framework);
                        NewPortletPluginProjectPage.this.getDataModel().setBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_ENABLED", this.val$delegate.isFragmentEnabled());
                    }
                });
                buttons.add(templateButton);
                final URL helpUrl = framework.getHelpUrl();
                Link descriptionWithLink = SWTUtil.createLink((Composite)group, (int)64, (String)(String.valueOf(framework.getDescription()) + (helpUrl != null ? " <a>Learn more....</a>" : "")), (int)1);
                descriptionWithLink.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
                if (helpUrl != null) {
                    descriptionWithLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            try {
                                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(helpUrl);
                            }
                            catch (Exception e1) {
                                ProjectUIPlugin.logError("Could not open external browser", e1);
                            }
                        }
                    });
                }
                ++n2;
            }
            this.frameworkButtons = buttons.toArray(new Button[0]);
            this.frameworkButtons[0].setSelection(true);
        }
    }

    protected void createTemplateOptionsGroup(Composite parent) {
        if (CoreUtil.isNullOrEmpty((Object[])this.frameworkButtons)) {
            return;
        }
        final Composite stackComposite = new Composite(parent, 0);
        stackComposite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        final StackLayout optionsLayout = new StackLayout();
        stackComposite.setLayout((Layout)optionsLayout);
        ArrayList<Composite> composites = new ArrayList<Composite>();
        Button[] buttonArray = this.frameworkButtons;
        int n = this.frameworkButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button templateButton = buttonArray[n2];
            IPortletFramework template = (IPortletFramework)templateButton.getData();
            IPortletFrameworkDelegate delegate = ProjectUIPlugin.getPortletFrameworkDelegate(template.getId());
            final Composite[] optionsComposite = new Composite[1];
            if (delegate != null) {
                optionsComposite[0] = delegate.createNewProjectOptionsComposite(stackComposite, this.getDataModel());
            }
            templateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    optionsLayout.topControl = optionsComposite[0];
                    stackComposite.layout();
                }
            });
            if (optionsComposite[0] == null) {
                optionsComposite[0] = SWTUtil.createComposite((Composite)stackComposite, (int)1, (int)1, (int)4);
                ((GridData)optionsComposite[0].getLayoutData()).verticalAlignment = 128;
            }
            composites.add(optionsComposite[0]);
            ++n2;
        }
        this.optionsComposites = composites.toArray(new Composite[0]);
        optionsLayout.topControl = this.optionsComposites[0];
        stackComposite.layout();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = SWTUtil.createTopComposite((Composite)parent, (int)1);
        this.createFrameworkGroup(top);
        this.createTemplateOptionsGroup(top);
        this.getModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET".equals(event.getPropertyName())) {
                    NewPortletPluginProjectPage.this.validatePage(false);
                }
            }
        });
        return top;
    }

    protected IDataModel getModel() {
        return this.model;
    }

    protected String getModuleFacetID() {
        return "jst.web";
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_ENABLED", "IPluginProjectDataModelProperties.PORTLET_FRAMEWORK"};
    }
}

