/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.project.ui.wizard.LiferaySDKField;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public class SDKProjectsImportWizardPage
extends DataModelFacetCreationWizardPage
implements ISDKProjectsImportDataModelProperties {
    protected long lastModified;
    protected String lastPath;
    protected CheckboxTreeViewer projectsList;
    protected Text sdkLocation;
    protected Text sdkVersion;
    protected ProjectRecord[] selectedProjects = new ProjectRecord[0];
    protected Combo serverTargetCombo;
    protected IProject[] wsProjects;

    public SDKProjectsImportWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle("Import Liferay Projects");
        this.setDescription("Select a Liferay Plugin SDK and import existing projects.");
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                this.selectedProjects[i].setHasConflicts(true);
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    public void updateProjectsList(String path) {
        Object[] checkedProjects;
        if (path == null || path.length() == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    SDKProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList eclipseProjectFiles = new ArrayList();
                    ArrayList liferayProjectDirs = new ArrayList();
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        if (!ProjectUtil.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, (File)directory, null, (boolean)true, (IProgressMonitor)monitor)) {
                            return;
                        }
                        SDKProjectsImportWizardPage.this.selectedProjects = new ProjectRecord[eclipseProjectFiles.size() + liferayProjectDirs.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                        for (File eclipseProjectFile : eclipseProjectFiles) {
                            SDKProjectsImportWizardPage.this.selectedProjects[index++] = new ProjectRecord(eclipseProjectFile);
                        }
                        for (File liferayProjectDir : liferayProjectDirs) {
                            SDKProjectsImportWizardPage.this.selectedProjects[index++] = new ProjectRecord(liferayProjectDir);
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ProjectUIPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        boolean displayWarning = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].hasConflicts()) {
                displayWarning = true;
                this.projectsList.setGrayed((Object)projects[i], true);
            }
            ++i;
        }
        if (displayWarning) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
        if ((checkedProjects = this.projectsList.getCheckedElements()) != null && checkedProjects.length > 0) {
            this.selectedProjects = new ProjectRecord[checkedProjects.length];
            int i2 = 0;
            while (i2 < checkedProjects.length) {
                this.selectedProjects[i2] = (ProjectRecord)checkedProjects[i2];
                ++i2;
            }
            this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.selectedProjects);
        }
    }

    protected void createPluginsSDKField(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.synchHelper.synchAllUIWithModel();
                SDKProjectsImportWizardPage.this.updateProjectsList(SDKProjectsImportWizardPage.this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION"));
                SDKProjectsImportWizardPage.this.validatePage(true);
            }
        };
        new LiferaySDKField(parent, this.getDataModel(), selectionAdapter, "ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME", this.synchHelper);
    }

    protected void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Projects to import:");
        title.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.projectsList = new CheckboxTreeViewer(workArea, 2048);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return SDKProjectsImportWizardPage.this.getProjectRecords();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.hasConflicts()) {
                    SDKProjectsImportWizardPage.this.projectsList.setChecked((Object)element, false);
                }
                SDKProjectsImportWizardPage.this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)SDKProjectsImportWizardPage.this.projectsList.getCheckedElements());
                SDKProjectsImportWizardPage.this.setPageComplete(SDKProjectsImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(workArea);
    }

    protected void createSDKLocationField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay Plugin SDK Location:", (int)1);
        this.sdkLocation = SWTUtil.createText((Composite)topComposite, (int)1);
        ((GridData)this.sdkLocation.getLayoutData()).widthHint = 300;
        this.synchHelper.synchText(this.sdkLocation, "ISDKProjectsImportDataModelProperties.SDK_LOCATION", null);
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"", (int)1);
    }

    protected void createSDKVersionField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay Plugin SDK Version:", (int)1);
        this.sdkVersion = SWTUtil.createText((Composite)topComposite, (int)1);
        this.synchHelper.synchText(this.sdkVersion, "ISDKProjectsImportDataModelProperties.SDK_VERSION", null);
        SWTUtil.createLabel((Composite)topComposite, (String)"", (int)1);
    }

    protected void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText("Select All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < SDKProjectsImportWizardPage.this.selectedProjects.length) {
                    if (SDKProjectsImportWizardPage.this.selectedProjects[i].hasConflicts()) {
                        SDKProjectsImportWizardPage.this.projectsList.setChecked((Object)SDKProjectsImportWizardPage.this.selectedProjects[i], false);
                    } else {
                        SDKProjectsImportWizardPage.this.projectsList.setChecked((Object)SDKProjectsImportWizardPage.this.selectedProjects[i], true);
                    }
                    ++i;
                }
                SDKProjectsImportWizardPage.this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)SDKProjectsImportWizardPage.this.projectsList.getCheckedElements());
                SDKProjectsImportWizardPage.this.validatePage(true);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                SDKProjectsImportWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText("Refresh");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectsImportWizardPage.this.lastModified = -1L;
                SDKProjectsImportWizardPage.this.updateProjectsList(SDKProjectsImportWizardPage.this.sdkLocation.getText().trim());
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    protected void createTargetRuntimeGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Liferay target runtime:");
        label.setLayoutData((Object)new GridData(32));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText("New...");
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = SDKProjectsImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)SDKProjectsImportWizardPage.this.getShell(), (String)SDKProjectsImportWizardPage.this.getModuleTypeID(), null, (String)"com.liferay.ide.eclipse.server");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = SDKProjectsImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        SDKProjectsImportWizardPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        GridLayout gl = new GridLayout(3, false);
        topComposite.setLayout((Layout)gl);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createPluginsSDKField(topComposite);
        SWTUtil.createSeparator((Composite)topComposite, (int)3);
        this.createSDKLocationField(topComposite);
        this.createSDKVersionField(topComposite);
        SWTUtil.createVerticalSpacer((Composite)topComposite, (int)1, (int)3);
        this.createProjectsList(topComposite);
        this.createTargetRuntimeGroup(topComposite);
        return topComposite;
    }

    protected void enter() {
        SDK initialSdk;
        String sdkName = this.getDataModel().getStringProperty("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME");
        if (sdkName != null && (initialSdk = SDKManager.getInstance().getSDK(sdkName)) != null) {
            this.updateProjectsList(initialSdk.getLocation().toOSString());
        }
    }

    protected IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"ISDKProjectsImportDataModelProperties.SDK_LOCATION", "ISDKProjectsImportDataModelProperties.SDK_VERSION", "ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME"};
    }

    protected void handleFileBrowseButton(Text text) {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setText("Select Liferay Plugin SDK folder");
        if (!CoreUtil.isNullOrEmpty((String)this.sdkLocation.getText())) {
            dd.setFilterPath(this.sdkLocation.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            this.sdkLocation.setText(dir);
            this.updateProjectsList(dir);
            this.synchHelper.synchAllUIWithModel();
            this.validatePage();
        }
    }

    protected boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    protected final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        protected ProjectLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts()) {
                return SDKProjectsImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }

        public String getText(Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }
    }
}

