/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.service.core.model.internal;

import com.liferay.ide.eclipse.service.core.ServiceCore;
import com.liferay.ide.eclipse.service.core.model.IColumn;
import com.liferay.ide.eclipse.service.core.model.IEntity;
import com.liferay.ide.eclipse.service.core.model.IRelationship;
import com.liferay.ide.eclipse.service.core.model.IServiceBuilder;
import com.liferay.ide.eclipse.service.core.model.internal.RelationshipResource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.internal.MemoryResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipsBinding
extends ListBindingImpl {
    protected List<Resource> localResources = new ArrayList<Resource>();
    private RelationshipListener listener;

    public List<Resource> read() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        final IEntity thisEntity = this.getEntity();
        IServiceBuilder root = (IServiceBuilder)this.element().root();
        ArrayList<IColumn> primaryColumns = new ArrayList<IColumn>();
        for (IEntity entity : root.getEntities()) {
            if (entity.equals(thisEntity)) continue;
            for (IColumn column : entity.getColumns()) {
                if (!((Boolean)column.isPrimary().getContent()).booleanValue()) continue;
                primaryColumns.add(column);
            }
        }
        for (final IColumn column : this.getColumns()) {
            if (((Boolean)column.isPrimary().getContent()).booleanValue()) continue;
            for (final IColumn primaryColumn : primaryColumns) {
                try {
                    if (!((String)primaryColumn.getName().getContent()).equals(column.getName().getContent()) || !((String)primaryColumn.getType().getContent()).equals(column.getType().getContent())) continue;
                    IRelationship rel = (IRelationship)IRelationship.TYPE.instantiate();
                    rel.setName((String)((IEntity)primaryColumn.parent().parent()).getName().getContent());
                    rel.setForeignKeyColumnName((String)column.getName().getContent());
                    final RelationshipResource resource = new RelationshipResource(thisEntity.resource(), rel);
                    resources.add(resource);
                    column.addListener(new ModelElementListener(){

                        public void propertyChanged(ModelPropertyChangeEvent event) {
                            if ("Name".equals(event.getProperty().getName()) || "Type".equals(event.getProperty().getName())) {
                                if (!((String)primaryColumn.getName().getContent()).equals(column.getName().getContent()) || !((String)primaryColumn.getType().getContent()).equals(column.getType().getContent())) {
                                    RelationshipsBinding.this.localResources.remove(resource);
                                }
                                thisEntity.refresh();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    ServiceCore.logError(e);
                }
            }
        }
        resources.addAll(this.localResources);
        return resources;
    }

    protected ModelElementList<IColumn> getColumns() {
        return this.getEntity().getColumns();
    }

    protected IEntity getEntity() {
        return (IEntity)this.element();
    }

    public ModelElementType type(Resource resource) {
        if (resource instanceof RelationshipResource) {
            return IRelationship.TYPE;
        }
        return null;
    }

    public Resource add(ModelElementType type) {
        IRelationship rel = (IRelationship)IRelationship.TYPE.instantiate();
        RelationshipResource resource = new RelationshipResource(this.getEntity().resource(), rel);
        this.localResources.add(resource);
        return resource;
    }

    public void remove(Resource resource) {
        if (resource instanceof RelationshipResource) {
            RelationshipResource relResource = (RelationshipResource)resource;
            IModelElement parentElement = resource.parent().element();
            if (parentElement instanceof IEntity) {
                IEntity referringEntity = (IEntity)parentElement;
                String fkColumnName = (String)relResource.getBase().getForeignKeyColumnName().getContent();
                IColumn remove = null;
                for (IColumn col : referringEntity.getColumns()) {
                    if (!((String)col.getName().getContent()).equals(fkColumnName)) continue;
                    remove = col;
                    break;
                }
                if (remove != null) {
                    referringEntity.getColumns().remove(remove);
                }
            }
        }
        if (this.localResources.contains(resource)) {
            this.localResources.remove(resource);
            resource.element().removeListener((ModelElementListener)this.listener);
        }
        this.getEntity().refresh();
    }

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.listener = new RelationshipListener();
        this.localResources.clear();
        MemoryResource memory = new MemoryResource(IRelationship.TYPE);
        memory.init(element);
        element.addListener(new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                RelationshipsBinding.this.handleRelationshipsChangedEvent(event);
            }
        }, new ModelPath("Relationships"));
    }

    protected void handleRelationshipsChangedEvent(ModelPropertyChangeEvent event) {
        IEntity entity = (IEntity)event.getModelElement();
        for (IRelationship rel : entity.getRelationships()) {
            rel.addListener(this.listener);
        }
    }

    protected void handleNameChangedEvent(ModelPropertyChangeEvent event) {
        System.out.println(event);
    }

    public class RelationshipListener
    extends ModelElementListener {
        public void propertyChanged(ModelPropertyChangeEvent event) {
            IRelationship rel = (IRelationship)event.getModelElement();
            IEntity e = (IEntity)rel.getName().resolve();
            if (e != null) {
                IEntity entity = RelationshipsBinding.this.getEntity();
                for (IColumn col : e.getColumns()) {
                    if (!((Boolean)col.isPrimary().getContent()).booleanValue()) continue;
                    boolean hasForeignKey = false;
                    for (IColumn col2 : entity.getColumns()) {
                        if (((Boolean)col2.isPrimary().getContent()).booleanValue() || !((String)col2.getName().getContent()).equals(col.getName().getContent())) continue;
                        hasForeignKey = true;
                    }
                    if (hasForeignKey) {
                        entity.getRelationships().remove((Object)rel);
                        continue;
                    }
                    IColumn foreignColumn = (IColumn)entity.getColumns().addNewElement();
                    foreignColumn.setName((String)col.getName().getContent());
                    foreignColumn.setType((String)col.getType().getContent());
                }
            }
        }
    }
}

