/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.theme.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import com.liferay.ide.eclipse.theme.core.ThemeCore;
import com.liferay.ide.eclipse.theme.core.operation.ThemeDescriptorHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntime;

public class ThemeDiffResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        if (this.shouldProcessResourceChangedEvent(event)) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (ThemeDiffResourceListener.this.shouldProcessResourceDelta(delta)) {
                            ThemeDiffResourceListener.this.processResourceChanged(delta);
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
    }

    private IFile getWorkspaceFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFile(path);
    }

    protected boolean isLiferayPluginProject(IPath deltaPath) {
        IFile pluginPackagePropertiesFile = this.getWorkspaceFile(deltaPath);
        if (pluginPackagePropertiesFile != null && pluginPackagePropertiesFile.exists()) {
            return ProjectUtil.isThemeProject((IProject)pluginPackagePropertiesFile.getProject());
        }
        return false;
    }

    protected void processResourceChanged(final IResourceDelta delta) throws CoreException {
        new WorkspaceJob("Compiling theme"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IProject project = delta.getResource().getProject();
                SDK sdk = SDKUtil.getSDK((IProject)project);
                if (sdk == null) {
                    throw new CoreException(ThemeCore.createErrorStatus("No SDK for project configured. Could not deploy theme module"));
                }
                Map appServerProperties = ServerUtil.configureAppServerProperties((IProject)project);
                IStatus status = sdk.compileThemePlugin(project, null, appServerProperties);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                IFolder docroot = CoreUtil.getDocroot((IProject)project);
                IFile lookAndFeelFile = docroot.getFile("WEB-INF/liferay-look-and-feel.xml");
                if (!lookAndFeelFile.exists()) {
                    IRuntime runtime;
                    ILiferayRuntime liferayRuntime;
                    String id = project.getName().replaceAll("-theme", "");
                    IFile propsFile = docroot.getFile("WEB-INF/liferay-plugin-package.properties");
                    String name = id;
                    if (propsFile.exists()) {
                        Properties props = new Properties();
                        try {
                            props.load(propsFile.getContents());
                            String nameValue = props.getProperty("name");
                            if (!CoreUtil.isNullOrEmpty((String)nameValue)) {
                                name = nameValue;
                            }
                        }
                        catch (IOException e) {
                            ThemeCore.logError("Unable to load plugin package properties.", e);
                        }
                    }
                    if ((liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)(runtime = ServerUtil.getRuntime((IProject)project)))) != null) {
                        ThemeDescriptorHelper.createDefaultFile(lookAndFeelFile, String.valueOf(liferayRuntime.getPortalVersion()) + "+", id, name);
                    }
                }
                if (docroot != null && docroot.exists()) {
                    docroot.refreshLocal(2, null);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected boolean shouldProcessResourceChangedEvent(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        IResourceDelta delta = event.getDelta();
        int deltaKind = delta.getKind();
        return deltaKind != 2 && deltaKind != 16;
    }

    protected boolean shouldProcessResourceDelta(IResourceDelta delta) {
        IPath fullPath = delta.getFullPath();
        IFolder docroot = CoreUtil.getDocroot((IProject)delta.getResource().getProject());
        if (docroot == null) {
            return false;
        }
        IPath diffPath = docroot.getFolder("_diffs").getFullPath();
        return diffPath.isPrefixOf(fullPath);
    }
}

