/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.theme.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.server.core.AbstractPluginPublisher;
import com.liferay.ide.eclipse.server.core.ILiferayServerBehavior;
import com.liferay.ide.eclipse.theme.core.ThemeCSSBuilder;
import com.liferay.ide.eclipse.theme.core.ThemeCore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class ThemePluginPublisher
extends AbstractPluginPublisher {
    public IStatus canPublishModule(IServer server, IModule module) {
        return Status.OK_STATUS;
    }

    public boolean prePublishModule(ServerBehaviourDelegate delegate, int kind, int deltaKind, IModule[] moduleTree, IModuleResourceDelta[] delta, IProgressMonitor monitor) {
        boolean publish = true;
        if (kind != 2 && kind != 1 && kind != 3 || moduleTree == null) {
            return publish;
        }
        if (deltaKind != 3) {
            try {
                this.addThemeModule(delegate, moduleTree[0]);
            }
            catch (Exception e) {
                ThemeCore.logError("Unable to pre-publish module.", e);
            }
        }
        return publish;
    }

    protected void addThemeModule(ServerBehaviourDelegate delegate, IModule module) throws CoreException {
        IProject project = module.getProject();
        IFolder docroot = CoreUtil.getDocroot((IProject)project);
        if (!(docroot == null || !docroot.exists() || docroot.exists((IPath)new Path("WEB-INF/liferay-look-and-feel.xml")) && docroot.exists((IPath)new Path("css")))) {
            ThemeCSSBuilder.cssBuild(project);
            ((ILiferayServerBehavior)delegate).redeployModule(new IModule[]{module});
        }
    }
}

