/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.theme.core.operation;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.theme.core.ThemeCore;
import com.liferay.ide.eclipse.theme.core.operation.INewThemeDataModelProperties;
import com.liferay.ide.eclipse.theme.core.operation.ThemeDescriptorHelper;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;

public class NewThemeDataModelProvider
extends ArtifactEditOperationDataModelProvider
implements INewThemeDataModelProperties {
    protected TemplateContextType contextType;
    protected boolean ignoreLayoutOptionPropertySet = false;
    protected TemplateStore templateStore;

    public NewThemeDataModelProvider(TemplateStore templateStore, TemplateContextType contextType) {
        this.templateStore = templateStore;
        this.contextType = contextType;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME".equals(propertyName)) {
            return "New Template";
        }
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(propertyName)) {
            String name = this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME");
            if (!CoreUtil.isNullOrEmpty((String)name)) {
                return name.replaceAll("[^a-zA-Z0-9]+", "").toLowerCase();
            }
        } else {
            if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".tpl";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".wap.tpl";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE".equals(propertyName)) {
                return "/" + this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID") + ".png";
            }
            if ("INewLayoutTplModelProperties.LAYOUT_IMAGE_BLANK_COLUMN".equals(propertyName)) {
                return true;
            }
            if ("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN".equals(propertyName) || "INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN".equals(propertyName)) {
                return false;
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_IMAGE_BLANK_COLUMN");
        propertyNames.add("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED");
        return propertyNames;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean isLayoutOption = false;
        int i = 0;
        while (i < LAYOUT_PROPERTIES.length) {
            if (LAYOUT_PROPERTIES[i].equals(propertyName)) {
                isLayoutOption = true;
                break;
            }
            ++i;
        }
        if (isLayoutOption && !this.ignoreLayoutOptionPropertySet) {
            this.ignoreLayoutOptionPropertySet = true;
            i = 0;
            while (i < LAYOUT_PROPERTIES.length) {
                this.setBooleanProperty(LAYOUT_PROPERTIES[i], false);
                ++i;
            }
            this.setProperty(propertyName, propertyValue);
            this.ignoreLayoutOptionPropertySet = false;
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        IFile thumbnailFile;
        if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(propertyName)) {
            IProject targetProject = this.getTargetProject();
            if (targetProject == null) {
                return ThemeCore.createErrorStatus("Target project is null.");
            }
            ThemeDescriptorHelper helper = new ThemeDescriptorHelper(targetProject);
            if (helper.hasTemplateId(this.getStringProperty(propertyName))) {
                return ThemeCore.createErrorStatus("Template id already exists in project.");
            }
            String idValue = String.valueOf(this.getStringProperty(propertyName)) + "z";
            if (CoreUtil.isNullOrEmpty((String)idValue)) {
                return super.validate(propertyName);
            }
            IStatus status = JavaConventions.validateFieldName((String)idValue, (String)"1.5", (String)"1.5");
            if (!status.isOK()) {
                return ThemeCore.createErrorStatus("Template id is invalid.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE".equals(propertyName)) {
            IFile templateFile = CoreUtil.getDocroot((IProject)this.getTargetProject()).getFile(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE"));
            if (templateFile.exists()) {
                return ThemeCore.createWarningStatus("Template file already exists and will be overwritten.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE".equals(propertyName)) {
            IFile wapTemplateFile = CoreUtil.getDocroot((IProject)this.getTargetProject()).getFile(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE"));
            if (wapTemplateFile.exists()) {
                return ThemeCore.createWarningStatus("WAP template file already exists and will be overwritten.");
            }
        } else if ("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE".equals(propertyName) && (thumbnailFile = CoreUtil.getDocroot((IProject)this.getTargetProject()).getFile(this.getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE"))).exists()) {
            return ThemeCore.createWarningStatus("Thumbnail file already exists and will be overwritten.");
        }
        return super.validate(propertyName);
    }

    protected IStatus validateListItems(String propertyName) {
        List itemsList;
        Object items = this.getProperty(propertyName);
        if (items instanceof List && (itemsList = (List)items).size() > 0) {
            return Status.OK_STATUS;
        }
        return ThemeCore.createErrorStatus("Need to specify at least one item.");
    }
}

