/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.theme.core.operation;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.DescriptorHelper;
import com.liferay.ide.eclipse.core.util.NodeUtil;
import com.liferay.ide.eclipse.theme.core.operation.INewThemeDataModelProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThemeDescriptorHelper
extends DescriptorHelper
implements INewThemeDataModelProperties {
    public static final String DEFUALT_FILE_TEMPLATE = "<?xml version=\"1.0\"?>\n<!DOCTYPE look-and-feel PUBLIC \"-//Liferay//DTD Look and Feel 6.0.0//EN\" \"http://www.liferay.com/dtd/liferay-look-and-feel_6_0_0.dtd\">\n\n<look-and-feel>\n\t<compatibility>\n\t\t<version>__VERSION__</version>\n\t</compatibility>\n\t<theme id=\"__ID__\" name=\"__NAME__\" />\n</look-and-feel>";

    public ThemeDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addNewLayoutTemplate(final IDataModel dm) {
        DescriptorHelper.DOMModelEditOperation operation = new DescriptorHelper.DOMModelEditOperation(this, this.getDescriptorFile("liferay-layout-templates.xml")){

            protected IStatus doExecute(IDOMDocument document) {
                return ThemeDescriptorHelper.this.doAddLayoutTemplate(document, dm);
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    public IStatus doAddLayoutTemplate(IDOMDocument document, IDataModel model) {
        Element docRoot = document.getDocumentElement();
        Element layoutTemplateElement = document.createElement("layout-template");
        layoutTemplateElement.setAttribute("id", model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID"));
        layoutTemplateElement.setAttribute("name", model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME"));
        Node customElement = NodeUtil.getFirstNamedChildNode((Element)docRoot, (String)"custom");
        if (customElement == null) {
            Node standardElement = NodeUtil.getFirstNamedChildNode((Element)docRoot, (String)"standard");
            customElement = document.createElement("custom");
            docRoot.insertBefore(customElement, standardElement);
        }
        customElement.appendChild(layoutTemplateElement);
        String templatePath = model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
        String wapTemplatePath = model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
        String thumbnailPath = model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE");
        ThemeDescriptorHelper.appendChildElement((Element)layoutTemplateElement, (String)"template-path", (String)templatePath);
        ThemeDescriptorHelper.appendChildElement((Element)layoutTemplateElement, (String)"wap-template-path", (String)wapTemplatePath);
        ThemeDescriptorHelper.appendChildElement((Element)layoutTemplateElement, (String)"thumbnail-path", (String)thumbnailPath);
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode(customElement);
        return Status.OK_STATUS;
    }

    public boolean hasTemplateId(final String templateId) {
        if (CoreUtil.isNullOrEmpty((String)templateId)) {
            return false;
        }
        final boolean[] retval = new boolean[1];
        DescriptorHelper.DOMModelReadOperation operation = new DescriptorHelper.DOMModelReadOperation(this, this.getDescriptorFile("liferay-layout-templates.xml")){

            protected IStatus doExecute(IDOMDocument document) {
                NodeList layoutTemplates = document.getElementsByTagName("layout-template");
                if (layoutTemplates != null && layoutTemplates.getLength() > 0) {
                    int i = 0;
                    while (i < layoutTemplates.getLength()) {
                        Element layoutTemplate = (Element)layoutTemplates.item(i);
                        if (templateId.equals(layoutTemplate.getAttribute("id"))) {
                            retval[0] = true;
                            break;
                        }
                        ++i;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        operation.execute();
        return retval[0];
    }

    public static void createDefaultFile(IFile lookAndFeelFile, String version, String id, String name) {
        if (lookAndFeelFile == null || id == null || name == null) {
            return;
        }
        try {
            CoreUtil.prepareFolder((IFolder)((IFolder)lookAndFeelFile.getParent()));
            String contents = DEFUALT_FILE_TEMPLATE.replaceAll("__VERSION__", version).replaceAll("__ID__", id).replaceAll("__NAME__", name);
            lookAndFeelFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

