/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.contextbuttons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.graphiti.internal.contextbuttons.PositionedContextButton;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextEntry;
import org.eclipse.graphiti.ui.internal.IResourceRegistryHolder;
import org.eclipse.graphiti.ui.internal.command.ContextEntryCommand;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.ITransparencyProvider;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.editor.GFDragConnectionTool;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.internal.util.draw2d.Tooltip;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ContextButton
extends Clickable
implements MouseMotionListener,
ActionListener {
    private ITransparencyProvider transparencyProvider = null;
    private PositionedContextButton positionedContextButton;
    private ContextButtonEntry contextButtonEntry;
    private ContextButtonPad contextButtonPad;
    private double opacity;
    private Tooltip tooltip;
    private MouseMoveListener mouseDragMoveListener;
    private MouseListener mouseDragUpListener;

    public ContextButton(PositionedContextButton positionedContextButton, ContextButtonPad contextButtonPad) {
        this.positionedContextButton = positionedContextButton;
        this.contextButtonPad = contextButtonPad;
        this.contextButtonEntry = (ContextButtonEntry)positionedContextButton.getContextButtonEntry();
        this.setBorder(null);
        this.setTransparencyProvider(contextButtonPad);
        this.setOpacity(this.getPositionedContextButton().getDefaultOpacity());
        if (this.getEntry().getText() != null && this.getEntry().getText().length() > 0) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            this.tooltip.setHeader(this.getEntry().getText());
        }
        if (this.getEntry().getDescription() != null && this.getEntry().getDescription().length() > 0) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            this.tooltip.setDescription(this.getEntry().getDescription());
        }
        this.setToolTip((IFigure)this.tooltip);
        this.addMouseMotionListener(this);
        this.addActionListener(this);
        if (this.getEntry().getDragAndDropFeatures().size() > 0) {
            this.setEnabled(true);
        } else if (this.getEntry().getContextButtonMenuEntries().size() > 0) {
            this.setEnabled(this.getExecutableMenuEntries().size() > 0);
        } else {
            this.setEnabled(this.getEntry().canExecute());
        }
    }

    public final PositionedContextButton getPositionedContextButton() {
        return this.positionedContextButton;
    }

    public final ContextButtonEntry getEntry() {
        return this.contextButtonEntry;
    }

    public final ContextButtonPad getContextButtonPad() {
        return this.contextButtonPad;
    }

    public final double getZoomLevel() {
        return this.getContextButtonPad().getZoomLevel();
    }

    public final DiagramEditorInternal getEditor() {
        return this.getContextButtonPad().getEditor();
    }

    public final EditPart getEditPart() {
        return this.getContextButtonPad().getEditPart();
    }

    private ITransparencyProvider getTransparencyProvider() {
        return this.transparencyProvider;
    }

    private void setTransparencyProvider(ITransparencyProvider transparencyProvider) {
        this.transparencyProvider = transparencyProvider;
    }

    private void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    private double getAdjustedOpacity() {
        if (this.getTransparencyProvider() != null) {
            return this.opacity * this.getTransparencyProvider().getCurrentTransparency();
        }
        return this.opacity;
    }

    protected void paintFigure(Graphics graphics) {
        boolean isSubmenuButton;
        Image image;
        int lw = (int)((double)this.getPositionedContextButton().getLineWidth() * this.getZoomLevel());
        graphics.setLineWidth(lw);
        graphics.setAntialias(1);
        graphics.setAlpha((int)(this.getAdjustedOpacity() * 255.0));
        Path pathOuterLine = this.createPath(1);
        Path pathMiddleLine = this.createPath(2);
        Path pathFill = this.createPath(3);
        graphics.setBackgroundColor(this.getAdjustedColor(this.getPositionedContextButton().getFillColor()));
        graphics.fillPath(pathFill);
        graphics.setForegroundColor(this.getAdjustedColor(this.getPositionedContextButton().getMiddleLineColor()));
        graphics.drawPath(pathMiddleLine);
        graphics.setForegroundColor(this.getAdjustedColor(this.getPositionedContextButton().getOuterLineColor()));
        graphics.drawPath(pathOuterLine);
        pathOuterLine.dispose();
        pathMiddleLine.dispose();
        pathFill.dispose();
        pathOuterLine = null;
        pathMiddleLine = null;
        pathFill = null;
        double imageOpacity = 1.0;
        graphics.setAlpha((int)(imageOpacity * 255.0));
        String iconId = this.getEntry().getIconId();
        Image originalImage = GraphitiUi.getImageService().getImageForId(iconId);
        if (!this.isEnabled()) {
            image = new Image(originalImage.getDevice(), originalImage, 1);
        } else {
            if (originalImage == null) {
                return;
            }
            image = new Image(originalImage.getDevice(), originalImage, 0);
        }
        org.eclipse.swt.graphics.Rectangle rect = image.getBounds();
        Rectangle newRect = new Rectangle(0, 0, rect.width, rect.height);
        newRect.scale(this.getZoomLevel());
        newRect.x = this.getBounds().x + (this.getBounds().width - newRect.width) / 2;
        newRect.y = this.getBounds().y + (this.getBounds().height - newRect.height) / 2;
        graphics.drawImage(image, rect.x, rect.y, rect.width, rect.height, newRect.x, newRect.y, newRect.width, newRect.height);
        image.dispose();
        List menuEntries = this.getEntry().getContextButtonMenuEntries();
        boolean bl = isSubmenuButton = menuEntries != null && menuEntries.size() > 0;
        if (isSubmenuButton) {
            this.paintSubmenuIndicator(graphics, newRect);
        }
    }

    private void paintSubmenuIndicator(Graphics graphics, Rectangle newRect) {
        int x = newRect.x;
        int y = newRect.y;
        int w = newRect.width;
        int h = newRect.height;
        PointList pl = new PointList();
        pl.addPoint(x + w, y + h * 3 / 4);
        pl.addPoint(x + w, y + h);
        pl.addPoint(x + w * 3 / 4, y + h);
        this.preparePaintIndicator(graphics);
        graphics.drawPolygon(pl);
        graphics.fillPolygon(pl);
    }

    private void paintDragOnlyIndicator(Graphics graphics, Rectangle newRect) {
        int x = newRect.x;
        int y = newRect.y;
        int w = newRect.width;
        int h = newRect.height;
        this.preparePaintIndicator(graphics);
        graphics.drawRectangle(x + w * 3 / 4, y + h / 2, w / 8, h / 8);
        graphics.fillRectangle(x + w * 3 / 4, y + h / 2, w / 8, h / 8);
    }

    private void paintDragOrClickIndicator(Graphics graphics, Rectangle newRect) {
        int x = newRect.x;
        int y = newRect.y;
        int w = newRect.width;
        int h = newRect.height;
        this.preparePaintIndicator(graphics);
        graphics.drawOval(x + w * 3 / 4, y + h / 4, w / 8, h / 8);
        graphics.fillOval(x + w * 3 / 4, y + h / 4, w / 8, h / 8);
    }

    private void preparePaintIndicator(Graphics graphics) {
        graphics.setLineWidth(1);
        IColorConstant outerLineColor = this.getPositionedContextButton().getOuterLineColor();
        Color adjustedColor = this.getAdjustedColor(outerLineColor);
        graphics.setForegroundColor(adjustedColor);
        graphics.setBackgroundColor(adjustedColor);
    }

    private Color getAdjustedColor(IColorConstant color) {
        DiagramEditorInternal editor = this.getContextButtonPad().getEditor();
        if (!this.isEnabled()) {
            int disabledAdjustment = 80;
            int r = Math.min(255, color.getRed() + disabledAdjustment);
            int g = Math.min(255, color.getGreen() + disabledAdjustment);
            int b = Math.min(255, color.getBlue() + disabledAdjustment);
            color = new ColorConstant(r, g, b);
        }
        Color swtColor = DataTypeTransformation.toSwtColor((IResourceRegistryHolder)editor, color);
        return swtColor;
    }

    protected Path createPath(int shrinkLines) {
        double zoom = this.getZoomLevel();
        int lw = (int)((double)this.getPositionedContextButton().getLineWidth() * zoom);
        Rectangle r = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, shrinkLines * lw);
        double zoomedCorner = (double)this.getPositionedContextButton().getCornerRadius() * zoom;
        int corner = (int)Math.max(1.0, zoomedCorner - ((double)((shrinkLines - 1) * lw) + zoomedCorner / 64.0));
        Path path = new Path(null);
        path.moveTo((float)r.x, (float)r.y);
        path.addArc((float)r.x, (float)r.y, (float)corner, (float)corner, 90.0f, 90.0f);
        path.addArc((float)r.x, (float)(r.y + r.height - corner), (float)corner, (float)corner, 180.0f, 90.0f);
        path.addArc((float)(r.x + r.width - corner), (float)(r.y + r.height - corner), (float)corner, (float)corner, 270.0f, 90.0f);
        path.addArc((float)(r.x + r.width - corner), (float)r.y, (float)corner, (float)corner, 0.0f, 90.0f);
        path.close();
        return path;
    }

    public void handleMouseEntered(MouseEvent event) {
        this.setOpacity(this.getPositionedContextButton().getMouseOverOpacity());
        this.repaint();
        super.handleMouseEntered(event);
    }

    public void handleMouseExited(MouseEvent event) {
        this.setOpacity(this.getPositionedContextButton().getDefaultOpacity());
        this.repaint();
        super.handleMouseExited(event);
    }

    public void handleMousePressed(MouseEvent event) {
        this.setToolTip(null);
        this.setOpacity(this.getPositionedContextButton().getMouseDownOpacity());
        this.repaint();
        super.handleMousePressed(event);
    }

    public void handleMouseReleased(MouseEvent event) {
        this.setToolTip((IFigure)this.tooltip);
        this.setOpacity(this.getPositionedContextButton().getMouseOverOpacity());
        this.repaint();
        super.handleMouseReleased(event);
    }

    public void mouseDragged(MouseEvent me) {
        if (this.getEntry().getDragAndDropFeatures().size() == 0) {
            return;
        }
        me.consume();
        if (this.mouseDragMoveListener == null) {
            this.mouseDragMoveListener = new MouseMoveListener(){

                public void mouseMove(org.eclipse.swt.events.MouseEvent e) {
                    EditPart targetEditPart = ContextButton.this.getEditor().getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
                    ContextButton.this.createNewGFDragConnectionTool().continueConnection(ContextButton.this.getEditPart(), ContextButton.this.getEditor(), ContextButton.this.getEntry(), targetEditPart);
                }
            };
            this.mouseDragUpListener = new MouseAdapter(){

                public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                    ContextButton.this.getEditor().getGraphicalViewer().getControl().removeMouseListener(ContextButton.this.mouseDragUpListener);
                    ContextButton.this.getEditor().getGraphicalViewer().getControl().removeMouseMoveListener(ContextButton.this.mouseDragMoveListener);
                    ContextButton.this.mouseDragUpListener = null;
                    ContextButton.this.mouseDragMoveListener = null;
                }
            };
            this.getEditor().getGraphicalViewer().getControl().addMouseListener(this.mouseDragUpListener);
            this.getEditor().getGraphicalViewer().getControl().addMouseMoveListener(this.mouseDragMoveListener);
        }
    }

    private GFDragConnectionTool createNewGFDragConnectionTool() {
        DefaultEditDomain editDomain = this.getEditor().getEditDomain();
        GFDragConnectionTool dragConnectionTool = new GFDragConnectionTool();
        dragConnectionTool.setEditDomain((EditDomain)editDomain);
        editDomain.setActiveTool((Tool)dragConnectionTool);
        return dragConnectionTool;
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void actionPerformed(ActionEvent event) {
        if (this.getEntry().getContextButtonMenuEntries().size() > 0) {
            List<IContextButtonEntry> menuEntries = this.getExecutableMenuEntries();
            if (menuEntries.size() == 0) {
                return;
            }
            PopupMenuLabelProvider labelProvider = new PopupMenuLabelProvider();
            PopupMenu popupMenu = new PopupMenu(menuEntries, (ILabelProvider)labelProvider);
            boolean b = popupMenu.show((Control)Display.getCurrent().getActiveShell());
            if (b) {
                ((ContextButtonEntry)popupMenu.getResult()).execute();
            }
        } else if (this.getEntry().canExecute()) {
            this.getEditor().getEditDomain().getCommandStack().execute((Command)new ContextEntryCommand((IContextEntry)this.getEntry()));
        }
        this.getContextButtonPad().getEditor().getContextButtonManager().hideContextButtonsInstantly();
    }

    private List<IContextButtonEntry> getExecutableMenuEntries() {
        List contextButtonMenuEntries = this.getEntry().getContextButtonMenuEntries();
        ArrayList<IContextButtonEntry> menuEntries = new ArrayList<IContextButtonEntry>();
        for (IContextButtonEntry contextButtonEntry : contextButtonMenuEntries) {
            if (!contextButtonEntry.canExecute()) continue;
            menuEntries.add(contextButtonEntry);
        }
        return menuEntries;
    }

    private class PopupMenuLabelProvider
    extends LabelProvider {
        private PopupMenuLabelProvider() {
        }

        public String getText(Object element) {
            return ((ContextButtonEntry)element).getText();
        }

        public Image getImage(Object element) {
            return GraphitiUi.getImageService().getImageForId(((ContextButtonEntry)element).getIconId());
        }
    }
}

