/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFHandleHelper;

public class ZoomingInsetsHandleLocator
implements Locator {
    private IFigure reference;
    private IConfigurationProvider configurationProvider;
    private Insets handleInsets;

    public ZoomingInsetsHandleLocator(IFigure reference, IConfigurationProvider configurationProvider, Insets handleInsets) {
        this.reference = reference;
        this.configurationProvider = configurationProvider;
        this.handleInsets = handleInsets;
    }

    public void relocate(IFigure target) {
        Insets insets = new Insets(this.handleInsets);
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        insets.top = (int)((double)insets.top * zoom);
        insets.bottom = (int)((double)insets.bottom * zoom);
        insets.left = (int)((double)insets.left * zoom);
        insets.right = (int)((double)insets.right * zoom);
        Rectangle bounds = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds() : this.reference.getBounds();
        bounds = new PrecisionRectangle(bounds.getCopy());
        this.reference.translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        bounds.translate(-insets.left, -insets.top);
        bounds.resize(insets.getWidth(), insets.getHeight());
        target.setBounds(bounds);
    }
}

