/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.LoggingService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionsLocatorFactory
extends ExtensionsLocator.Factory {
    public boolean applicable() {
        return FrameworkUtil.getBundle(ExtensionsLocatorFactory.class) != null;
    }

    public ExtensionsLocator create() {
        return new ExtensionsLocator(){

            public List<ExtensionsLocator.Handle> find() {
                BundleContext context = FrameworkUtil.getBundle(ExtensionsLocatorFactory.class).getBundleContext();
                ArrayList<1> handles = new ArrayList<1>();
                Bundle[] bundleArray = context.getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final Bundle bundle = bundleArray[n2];
                    int state = bundle.getState();
                    if (state == 4 || state == 8 || state == 32) {
                        Enumeration urls = null;
                        try {
                            urls = bundle.getResources("META-INF/sapphire-extension.xml");
                        }
                        catch (Exception e) {
                            LoggingService.log((Exception)e);
                        }
                        if (urls != null) {
                            while (urls.hasMoreElements()) {
                                final URL url = (URL)urls.nextElement();
                                if (ExtensionsLocatorFactory.contains(handles, url)) continue;
                                ExtensionsLocator.Handle handle = new ExtensionsLocator.Handle(){

                                    public URL extension() {
                                        return url;
                                    }

                                    public URL findResource(String name) {
                                        return bundle.getResource(name);
                                    }

                                    public <T> Class<T> findClass(String name) {
                                        try {
                                            return bundle.loadClass(name);
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            return null;
                                        }
                                    }
                                };
                                handles.add(handle);
                            }
                        }
                    }
                    ++n2;
                }
                return Collections.unmodifiableList(handles);
            }
        };
    }

    private static boolean contains(List<ExtensionsLocator.Handle> handles, URL url) {
        for (ExtensionsLocator.Handle handle : handles) {
            if (!url.toString().equals(handle.extension().toString())) continue;
            return true;
        }
        return false;
    }
}

