/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.cmd;

import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import org.eclipse.gef.commands.Command;

public class PortletColumnCreateCommand
extends Command {
    protected LayoutTplDiagram diagram;
    protected LayoutConstraint layoutConstraint;
    protected PortletColumn newColumn;

    public PortletColumnCreateCommand(PortletColumn newColumn, LayoutTplDiagram diagram, LayoutConstraint constraint) {
        this.newColumn = newColumn;
        this.diagram = diagram;
        this.layoutConstraint = constraint;
        this.setLabel("Portlet column added");
    }

    public boolean canExecute() {
        return this.newColumn != null && this.diagram != null && this.layoutConstraint != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.layoutConstraint.equals(LayoutConstraint.EMPTY) || this.layoutConstraint.newColumnIndex == -1) {
            PortletLayout portletLayout = new PortletLayout();
            portletLayout.addColumn(this.newColumn);
            this.diagram.addRow(portletLayout, this.layoutConstraint.newRowIndex);
        } else if (this.layoutConstraint.rowIndex > -1 && this.layoutConstraint.newColumnIndex > -1) {
            if (this.layoutConstraint.refColumn != null) {
                this.layoutConstraint.refColumn.setWeight(this.layoutConstraint.weight);
            }
            this.newColumn.setWeight(this.layoutConstraint.weight);
            ModelElement row = this.diagram.getRows().get(this.layoutConstraint.rowIndex);
            PortletLayout portletLayout = (PortletLayout)row;
            if (row != null) {
                portletLayout.addColumn(this.newColumn, this.layoutConstraint.newColumnIndex);
            }
        }
    }

    public void undo() {
        if (this.layoutConstraint.equals(LayoutConstraint.EMPTY)) {
            for (ModelElement row : this.diagram.getRows()) {
                PortletLayout portletLayout = (PortletLayout)row;
                if (portletLayout.getColumns().size() != 1 || !portletLayout.getColumns().get(0).equals(this.newColumn)) continue;
                this.diagram.removeRow(portletLayout);
            }
        } else {
            System.out.println("UNDO not supported!");
        }
    }
}

