/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.parts;

import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.parts.BaseGraphicalEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.parts.PortletColumnEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.parts.PortletLayoutEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.policies.LayoutTplDiagramLayoutEditPolicy;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTplDiagramEditPart
extends BaseGraphicalEditPart {
    public static final int DIAGRAM_MARGIN = 10;
    public static final int DEFAULT_COLUMN_HEIGHT = -1;
    protected Panel diagramPanel;
    protected boolean shouldUpdateConstraints = false;

    public int getContainerWidth() {
        return this.diagramPanel.getSize().width - 20;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("LayoutTplDiagram.RowAdded".equals(prop) || "LayoutTplDiagram.RowRemoved".equals(prop)) {
            this.refreshChildren();
            List rows = this.getChildren();
            if (rows.size() > 0) {
                for (Object row : rows) {
                    AbstractEditPart rowPart = (AbstractEditPart)row;
                    List cols = rowPart.getChildren();
                    if (cols.size() > 0) {
                        for (Object col : cols) {
                            ((AbstractEditPart)col).refresh();
                        }
                    }
                    ((AbstractEditPart)row).refresh();
                }
            }
            this.refreshVisuals();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LayoutTplDiagramLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        this.diagramPanel = new Panel();
        this.configureDiagramPanel(this.diagramPanel);
        return this.diagramPanel;
    }

    protected void configureDiagramPanel(Panel panel) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        panel.setLayoutManager((LayoutManager)gridLayout);
        panel.setBackgroundColor(new Color(null, 10, 10, 10));
        panel.setBorder((Border)new MarginBorder(10));
        panel.addLayoutListener(new LayoutListener(){

            public void invalidate(IFigure container) {
                LayoutTplDiagramEditPart.this.shouldUpdateConstraints = true;
            }

            public boolean layout(IFigure container) {
                return false;
            }

            public void postLayout(IFigure container) {
                if (LayoutTplDiagramEditPart.this.shouldUpdateConstraints) {
                    LayoutTplDiagramEditPart.this.updateColumnConstraints();
                }
            }

            public void remove(IFigure child) {
            }

            public void setConstraint(IFigure child, Object constraint) {
            }
        });
    }

    protected void updateColumnConstraints() {
        try {
            try {
                for (Object row : this.getChildren()) {
                    PortletLayoutEditPart rowPart = (PortletLayoutEditPart)row;
                    for (Object col : ((EditPart)row).getChildren()) {
                        PortletColumnEditPart columnPart = (PortletColumnEditPart)col;
                        Object constraint = rowPart.getLayoutConstraint(columnPart, columnPart.getFigure());
                        if (!(constraint instanceof GridData)) continue;
                        GridData gd = (GridData)constraint;
                        int columnHeight = this.getPreferredColumnHeight();
                        if (columnHeight > 0) {
                            gd.heightHint = columnHeight;
                        } else {
                            gd.heightHint = -1;
                            gd.grabExcessVerticalSpace = true;
                        }
                        rowPart.setLayoutConstraint((EditPart)columnPart, columnPart.getFigure(), gd);
                    }
                }
            }
            catch (Exception exception) {
                this.shouldUpdateConstraints = false;
            }
        }
        finally {
            this.shouldUpdateConstraints = false;
        }
    }

    protected LayoutTplDiagram getCastedModel() {
        return (LayoutTplDiagram)this.getModel();
    }

    protected List<ModelElement> getModelChildren() {
        return this.getCastedModel().getRows();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        List children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof AbstractEditPart)) continue;
            ((AbstractEditPart)child).refresh();
        }
    }

    public int getPreferredColumnHeight() {
        int retval = -1;
        int numRows = this.getRowPartsCount();
        if (numRows > 1) {
            Rectangle partBounds = this.getFigure().getBounds();
            if (partBounds.height > 0) {
                int computedColumnHeight;
                int partHeight = partBounds.height;
                int rowsHeight = partHeight - 20;
                int totalColumnsHeight = rowsHeight - this.getRowPartsCount() * 10 * 2;
                retval = computedColumnHeight = totalColumnsHeight / numRows;
            }
        }
        return retval;
    }

    protected int getRowPartsCount() {
        return this.getChildren().size();
    }
}

