/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.parts;

import com.liferay.ide.eclipse.layouttpl.ui.draw2d.PortletLayoutPanel;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.parts.BaseGraphicalEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.parts.LayoutTplDiagramEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.parts.PortletColumnEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.policies.PortletLayoutLayoutEditPolicy;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletLayoutEditPart
extends BaseGraphicalEditPart {
    public static final int COLUMN_SPACING = 10;
    public static final int LAYOUT_MARGIN = 10;
    protected LayoutListener layoutListener = new PortletLayoutLayoutListener();
    protected PortletLayoutPanel layoutPanel;
    protected boolean needsRefreshPostLayout;

    public static GridData createGridData() {
        return new GridData(4, 4, true, true, 1, 1);
    }

    public int getDefaultColumnHeight() {
        return this.getCastedParent().getPreferredColumnHeight();
    }

    public Object getLayoutConstraint(PortletColumnEditPart columnPart, IFigure figure) {
        if (this.getChildren().contains(columnPart)) {
            return this.getFigure().getLayoutManager().getConstraint(figure);
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("PortletLayout.ColumnAdded".equals(prop) || "PortletLayout.ColumnRemoved".equals(prop) || "PortletLayout.ChildColumnWeightChanged".equals(prop)) {
            this.refreshChildren();
            this.refreshVisuals();
        }
    }

    private LayoutTplDiagramEditPart getCastedParent() {
        return (LayoutTplDiagramEditPart)this.getParent();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PortletLayoutLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.layoutPanel = new PortletLayoutPanel();
        this.layoutPanel.setOpaque(true);
        this.layoutPanel.setBorder((Border)new MarginBorder(10));
        this.layoutPanel.setBackgroundColor(new Color(null, 171, 171, 171));
        this.layoutPanel.setLayoutManager((LayoutManager)gridLayout);
        this.layoutPanel.addLayoutListener(this.layoutListener);
        return this.layoutPanel;
    }

    protected PortletLayoutPanel getCastedFigure() {
        return (PortletLayoutPanel)this.getFigure();
    }

    protected PortletLayout getCastedModel() {
        return (PortletLayout)this.getModel();
    }

    protected List<ModelElement> getModelChildren() {
        return this.getCastedModel().getColumns();
    }

    protected LayoutTplDiagram getParentModel() {
        return (LayoutTplDiagram)this.getParent().getModel();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GridData gd = PortletLayoutEditPart.createGridData();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.layoutPanel, (Object)gd);
        List rows = this.getParent().getChildren();
        if (rows.size() == 1) {
            this.layoutPanel.setTop(true);
            this.layoutPanel.setBottom(true);
        } else if (this.equals(rows.get(0))) {
            this.layoutPanel.setTop(true);
            this.layoutPanel.setBottom(false);
        } else if (this.equals(rows.get(rows.size() - 1))) {
            this.layoutPanel.setTop(false);
            this.layoutPanel.setBottom(true);
        } else {
            this.layoutPanel.setTop(false);
            this.layoutPanel.setBottom(false);
        }
        PortletLayoutPanel panel = this.getCastedFigure();
        GridLayout gridLayout = (GridLayout)panel.getLayoutManager();
        List columns = this.getChildren();
        int numColumns = columns.size();
        if (numColumns > 1) {
            int rowWidth = this.getFigure().getSize().width - 20;
            if (rowWidth > 0) {
                for (Object col : columns) {
                    PortletColumnEditPart portletColumnPart = (PortletColumnEditPart)col;
                    PortletColumn column = (PortletColumn)portletColumnPart.getModel();
                    GridData rowData = portletColumnPart.createGridData();
                    double percent = (double)column.getWeight() / 100.0;
                    rowData.widthHint = (int)(percent * (double)rowWidth) - 20;
                    this.setLayoutConstraint((EditPart)portletColumnPart, portletColumnPart.getFigure(), rowData);
                }
            } else {
                this.needsRefreshPostLayout = true;
            }
        }
        gridLayout.numColumns = numColumns;
        gridLayout.invalidate();
        this.getFigure().repaint();
    }

    protected class PortletLayoutLayoutListener
    implements LayoutListener {
        protected PortletLayoutLayoutListener() {
        }

        public void invalidate(IFigure container) {
        }

        public boolean layout(IFigure container) {
            return false;
        }

        public void postLayout(IFigure container) {
            if (PortletLayoutEditPart.this.needsRefreshPostLayout) {
                PortletLayoutEditPart.this.needsRefreshPostLayout = false;
                PortletLayoutEditPart.this.refreshVisuals();
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }
}

