/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.policies;

import com.liferay.ide.eclipse.layouttpl.ui.cmd.PortletColumnCreateCommand;
import com.liferay.ide.eclipse.layouttpl.ui.cmd.PortletLayoutCreateCommand;
import com.liferay.ide.eclipse.layouttpl.ui.draw2d.FeedbackRoundedRectangle;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.parts.LayoutTplDiagramEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.util.LayoutTplUtil;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class LayoutTplDiagramLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    public static final int DEFAULT_FEEDBACK_HEIGHT = 20;
    protected IFigure layoutFeedbackFigure;

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        System.out.println("ColumnLayoutEditPolicy.createChangeConstraintCommand");
        return null;
    }

    protected IFigure createLayoutFeedbackFigure(Request request) {
        LayoutConstraint constraint = (LayoutConstraint)this.getConstraintFor((CreateRequest)request);
        if (constraint == null) {
            return null;
        }
        boolean isRowRequest = LayoutTplUtil.isCreateRequest(PortletLayout.class, request);
        boolean isColumnRequest = LayoutTplUtil.isCreateRequest(PortletColumn.class, request);
        FeedbackRoundedRectangle feedback = new FeedbackRoundedRectangle();
        if (isRowRequest || isColumnRequest) {
            feedback.setSize(this.getContainerWidth(), 20);
            List parts = this.getHost().getChildren();
            if (constraint.equals(LayoutConstraint.EMPTY)) {
                Rectangle r = new Rectangle();
                if (parts.size() > 0) {
                    for (Object part : parts) {
                        GraphicalEditPart editPart = (GraphicalEditPart)part;
                        r.union(editPart.getFigure().getBounds());
                    }
                }
                Point point = new Point(r.x, r.y + r.height);
                if (point.x < 10) {
                    point.x = 10;
                }
                if (point.y < 10) {
                    point.y = 10;
                }
                if (parts.size() > 0) {
                    point.y -= feedback.getSize().height / 2;
                }
                feedback.setLocation(point);
            } else if (constraint.newRowIndex == 0) {
                Rectangle r = new Rectangle();
                if (parts.size() > 0) {
                    GraphicalEditPart editPart = (GraphicalEditPart)parts.get(0);
                    r = editPart.getFigure().getBounds().getCopy();
                    r.y -= feedback.getSize().height / 2;
                }
                Point point = new Point(r.x, r.y);
                feedback.setLocation(point);
            }
        } else {
            feedback = null;
        }
        return feedback;
    }

    protected int getContainerWidth() {
        return this.getDiagramPart().getContainerWidth();
    }

    protected LayoutTplDiagramEditPart getDiagramPart() {
        return (LayoutTplDiagramEditPart)this.getHost();
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        if (this.layoutFeedbackFigure != null) {
            this.removeFeedback(this.layoutFeedbackFigure);
            this.getFeedbackLayer().repaint();
            this.layoutFeedbackFigure = null;
        }
    }

    protected Object getConstraintFor(Point point) {
        LayoutConstraint constraint = null;
        LayoutTplDiagramEditPart diagramPart = (LayoutTplDiagramEditPart)this.getHost();
        if (diagramPart.getChildren().size() == 0) {
            constraint = new LayoutConstraint();
        } else if (point.y < 20) {
            constraint = new LayoutConstraint();
            List parts = diagramPart.getChildren();
            int numParts = parts.size();
            if (numParts > 0) {
                constraint.newRowIndex = 0;
            }
        } else {
            List parts = diagramPart.getChildren();
            Rectangle r = new Rectangle();
            Dimension d = new Dimension();
            for (Object part : parts) {
                GraphicalEditPart editPart = (GraphicalEditPart)part;
                r.union(editPart.getFigure().getBounds().getSize());
                d.union(editPart.getFigure().getBounds().getSize());
            }
            if (point.y > r.height) {
                constraint = new LayoutConstraint();
                constraint.newRowIndex = -1;
            }
        }
        return constraint;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object childClass = request.getNewObjectType();
        if (childClass == PortletColumn.class) {
            return new PortletColumnCreateCommand((PortletColumn)request.getNewObject(), (LayoutTplDiagram)this.getHost().getModel(), (LayoutConstraint)this.getConstraintFor(request));
        }
        if (childClass == PortletLayout.class) {
            return new PortletLayoutCreateCommand((PortletLayout)request.getNewObject(), (LayoutTplDiagram)this.getHost().getModel(), (LayoutConstraint)this.getConstraintFor(request));
        }
        return null;
    }

    protected void showLayoutTargetFeedback(Request request) {
        super.showLayoutTargetFeedback(request);
        IFigure feedback = this.createLayoutFeedbackFigure(request);
        if (feedback != null && !feedback.equals(this.layoutFeedbackFigure)) {
            if (this.layoutFeedbackFigure != null) {
                this.removeFeedback(this.layoutFeedbackFigure);
            }
            this.layoutFeedbackFigure = feedback;
            this.addFeedback(this.layoutFeedbackFigure);
        }
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return null;
    }
}

